import {AdminLicenseCreateRoutable} from "@admin/license/components/routables/admin-license-create/admin-license-create.routable";
import {AdminLicenseDetailEditRoutable} from "@admin/license/components/routables/admin-license-detail-edit/admin-license-detail-edit.routable";
import {AdminLicenseListRoutable} from "@admin/license/components/routables/admin-license-list/admin-license-list.routable";
import {AdminLicenseState} from "@admin/license/stores/admin-license.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminLicenseListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.licenseCreate,
    component: AdminLicenseCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.licenseDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminLicenseDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminLicenseState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.licenseEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminLicenseRoutingModule {
}
