import {AdminLanguageCreateEditDialog} from "@admin/language/components/dialogs/admin-language-create-edit/admin-language-create-edit.dialog";
import {adminLanguageActionNameSpace} from "@admin/language/stores/admin-language.action";
import {AdminLanguageStateModel} from "@admin/language/stores/admin-language.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {Language} from "@models";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {CreateEditDialog} from "@shared/models/detail-edit-dialog.model";
import {RouterExtService} from "@shared/services/router-ext.service";
import {tap} from "rxjs/operators";
import {
  isNullOrUndefined,
  isTrue,
  isTruthyObject,
  OrderEnum,
  Override,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-language-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminLanguageListRoutable extends SharedAbstractListRoutable<Language, AdminLanguageStateModel> {
  readonly KEY_CREATE_BUTTON: string = LabelTranslateEnum.create;
  readonly KEY_BACK_BUTTON: string | undefined = LabelTranslateEnum.backToAdmin;
  readonly KEY_PARAM_NAME: keyof Language & string = "code";

  constructor(protected readonly _store: Store,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _route: ActivatedRoute,
              protected readonly _routerExt: RouterExtService,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog) {
    super(_store, _changeDetector, _route, _routerExt, _actions$, _dialog, LocalStateEnum.admin_language, adminLanguageActionNameSpace, {}, LocalStateEnum.admin);
  }

  conditionDisplayEditButton(model: Language | undefined): boolean {
    return false;
  }

  conditionDisplayDeleteButton(model: Language | undefined): boolean {
    return true;
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "resId",
        header: LabelTranslateEnum.identifier,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
        width: "100px",
      },
      {
        field: "code",
        header: LabelTranslateEnum.code,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "creation.when" as any,
        header: LabelTranslateEnum.created,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "lastUpdate.when" as any,
        header: LabelTranslateEnum.updated,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.descending,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }

  @Override()
  create(element: ElementRef): void {
    this.subscribe(this._dialog.open(AdminLanguageCreateEditDialog, {
      minWidth: "500px",
      data: {
        current: undefined,
      } as CreateEditDialog<Language>,
    }).afterClosed().pipe(
      tap((isConfirmed: boolean | undefined) => {
        if (isNullOrUndefined(isConfirmed)) {
          if (isTruthyObject(element)) {
            element.nativeElement.focus();
          }
          return;
        }
        if (isTrue(isConfirmed)) {
          if (isTruthyObject(element)) {
            element.nativeElement.focus();
          }
          this.getAll();
        }
      }),
    ));
  }

  @Override()
  goToEdit(model: Language): void {
  }

  @Override()
  showDetail(model: Language): void {
  }
}
