import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
  OnInit,
} from "@angular/core";
import {
  FormBuilder,
  Validators,
} from "@angular/forms";
import {Language} from "@models";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {Country} from "@shared/models/country.model";
import {RegionUtil} from "@shared/utils/region.util";
import {
  distinctUntilChanged,
  tap,
} from "rxjs/operators";
import {
  Override,
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-research-domain-form",
  templateUrl: "./admin-language-form.presentational.html",
  styleUrls: ["../../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminLanguageFormPresentational extends SharedAbstractFormPresentational<Language> implements OnInit {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();
  listCountry: Country[] = RegionUtil.getCountries();

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef, _elementRef);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.subscribe(this.form.get(this.formDefinition.resId).valueChanges.pipe(
      distinctUntilChanged(),
      tap((resId: string) => {
        this.form.get(this.formDefinition.code).setValue(resId.toLocaleLowerCase());
      }),
    ));
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.code]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.resId]: ["", [Validators.required, SolidifyValidator]],
    });
  }

  protected bindFormTo(languages: Language): void {
    this.form = this._fb.group({
      [this.formDefinition.code]: [languages.code, [Validators.required, SolidifyValidator]],
      [this.formDefinition.resId]: [languages.resId, [Validators.required, SolidifyValidator]],
    });
  }

  @Override()
  onSubmit(): void {
    const model = this.treatmentBeforeSubmit(this.form.value as Language);
    this._submitBS.next({
      model: model,
      formControl: this.form,
      changeDetectorRef: this._changeDetectorRef,
    });
  }

  protected treatmentBeforeSubmit(languages: Language): Language {
    return languages;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() code: string;
  @PropertyName() resId: string;
}
