import {adminLanguageActionNameSpace} from "@admin/language/stores/admin-language.action";
import {AdminLanguageStateModel} from "@admin/language/stores/admin-language.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Inject,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialog,
  MatDialogRef,
} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {Language} from "@models";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractCreateEditDialog} from "@shared/components/dialogs/shared-abstract-create-edit/shared-abstract-create-edit.dialog";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {CreateEditDialog} from "@shared/models/detail-edit-dialog.model";
import {sharedLanguageActionNameSpace} from "@shared/stores/language/shared-language.action";
import {
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-language-create-edit-dialog",
  templateUrl: "./admin-language-create-edit.dialog.html",
  styleUrls: ["./admin-language-create-edit.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminLanguageCreateEditDialog extends SharedAbstractCreateEditDialog<Language, AdminLanguageStateModel> {
  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedLanguageActionNameSpace;

  constructor(@Inject(MAT_DIALOG_DATA) protected readonly data: CreateEditDialog<Language>,
              protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _dialog: MatDialog,
              protected readonly _dialogRef: MatDialogRef<AdminLanguageCreateEditDialog>) {
    super(data, _store, _route, _actions$, _changeDetector, _dialog, _dialogRef, LocalStateEnum.admin_language, adminLanguageActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }

  readonly KEY_CANCEL_BUTTON: string | undefined;
  readonly KEY_CREATE_BUTTON: string;
  readonly KEY_CREATE_TITLE: string | undefined;
  readonly KEY_UPDATE_BUTTON: string;
  readonly KEY_UPDATE_TITLE: string | undefined;
}
