import {AdminLanguageRoutingModule} from "@admin/language/admin-language-routing.module";
import {AdminLanguageCreateEditDialog} from "@admin/language/components/dialogs/admin-language-create-edit/admin-language-create-edit.dialog";
import {AdminLanguageFormPresentational} from "@admin/language/components/presentationals/admin-language-form/admin-language-form.presentational";
import {AdminLanguageListRoutable} from "@admin/language/components/routables/admin-language-list/admin-language-list.routable";
import {AdminLanguageState} from "@admin/language/stores/admin-language.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminLanguageListRoutable,
];
const containers = [];
const dialogs = [
  AdminLanguageCreateEditDialog,
];
const presentationals = [
  AdminLanguageFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminLanguageRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminLanguageState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminLanguageModule {
}
