import {
  AdminInstitutionAction,
  adminInstitutionActionNameSpace,
} from "@admin/institution/stores/admin-institution.action";
import {HttpClient} from "@angular/common/http";
import {Injectable} from "@angular/core";
import {Institution} from "@models";
import {
  Action,
  Actions,
  Selector,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {ResourceLogoStateModel} from "@shared/stores/resource-logo/resource-logo-state.model";
import {
  defaultResourceLogoStateInitValue,
  ResourceLogoState,
  ResourceLogoStateModeEnum,
} from "@shared/stores/resource-logo/resource-logo.state";
import {
  ApiService,
  isNotNullNorUndefined,
  isNullOrUndefined,
  MARK_AS_TRANSLATABLE,
  NotificationService,
  OverrideDefaultAction,
  StoreUtil,
  urlSeparator,
} from "solidify-frontend";

export interface AdminInstitutionStateModel extends ResourceLogoStateModel<Institution> {

}

@Injectable()
@State<AdminInstitutionStateModel>({
  name: LocalStateEnum.admin_institution,
  defaults: {
    ...defaultResourceLogoStateInitValue(),
  },
})
export class AdminInstitutionState extends ResourceLogoState<AdminInstitutionStateModel, Institution> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions,
              protected readonly _httpClient: HttpClient) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminInstitutionActionNameSpace,
      routeRedirectUrlAfterSuccessCreateAction: (resId: string) => RoutesEnum.adminInstitutionDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessUpdateAction: (resId: string) => RoutesEnum.adminInstitutionDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessDeleteAction: RoutesEnum.adminInstitution,
      notificationResourceCreateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.institution.notification.resource.create"),
      notificationResourceDeleteSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.institution.notification.resource.delete"),
      notificationResourceUpdateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.institution.notification.resource.update"),
    }, _httpClient, ResourceLogoStateModeEnum.logo);
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.institutions;
  }

  protected get _urlLogoResource(): string {
    return this._urlResource;
  }

  @Selector()
  static isLoading(state: AdminInstitutionStateModel): boolean {
    return StoreUtil.isLoadingState(state);
  }

  @Selector()
  static isLoadingWithDependency(state: AdminInstitutionStateModel): boolean {
    return this.isLoading(state);
  }

  @Selector()
  static currentTitle(state: AdminInstitutionStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.name;
  }

  @Selector()
  static isReadyToBeDisplayed(state: AdminInstitutionStateModel): boolean {
    return this.isReadyToBeDisplayedInCreateMode
      && !isNullOrUndefined(state.current);
  }

  @Selector()
  static isReadyToBeDisplayedInCreateMode(state: AdminInstitutionStateModel): boolean {
    return true;
  }

  @OverrideDefaultAction()
  @Action(AdminInstitutionAction.GetByIdSuccess)
  getByIdSuccess(ctx: StateContext<AdminInstitutionStateModel>, action: AdminInstitutionAction.GetByIdSuccess): void {
    super.getByIdSuccess(ctx, action);
    if (isNotNullNorUndefined(action.model.logo)) {
      ctx.dispatch(new AdminInstitutionAction.GetPhoto(action.model.resId));
    }
  }
}
