import {AdminInstitutionAction} from "@admin/institution/stores/admin-institution.action";
import {AdminInstitutionState} from "@admin/institution/stores/admin-institution.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
} from "@angular/core";
import {
  FormBuilder,
  Validators,
} from "@angular/forms";
import {Institution} from "@models";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {ResourceLogoNameSpace} from "@shared/stores/resource-logo/resource-logo-namespace.model";
import {RegexpUtil} from "@shared/utils/regexp.util";
import {
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-institution-form",
  templateUrl: "./admin-institution-form.presentational.html",
  styleUrls: ["../../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminInstitutionFormPresentational extends SharedAbstractFormPresentational<Institution> {
  public formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  adminInstitutionActionNameSpace: ResourceLogoNameSpace = AdminInstitutionAction;
  adminInstitutionState: typeof AdminInstitutionState = AdminInstitutionState;

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef, _elementRef);
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.url]: ["", [SolidifyValidator, Validators.pattern(RegexpUtil.url)]],
      [this.formDefinition.description]: ["", [SolidifyValidator]],
      [this.formDefinition.emailSuffixes]: [[], [SolidifyValidator]],

    });
  }

  protected bindFormTo(institutions: Institution): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: [institutions.name, [Validators.required, SolidifyValidator]],
      [this.formDefinition.url]: [institutions.url, [SolidifyValidator, Validators.pattern(RegexpUtil.url)]],
      [this.formDefinition.description]: [institutions.description, [SolidifyValidator]],
      [this.formDefinition.emailSuffixes]: [[...institutions.emailSuffixes], [SolidifyValidator]],
    });
  }

  protected treatmentBeforeSubmit(institutions: Institution): Institution {
    return institutions;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() name: string;
  @PropertyName() url: string;
  @PropertyName() description: string;
  @PropertyName() emailSuffixes: string;
}
