import {AdminInstitutionRoutingModule} from "@admin/institution/admin-institution-routing.module";
import {AdminInstitutionFormPresentational} from "@admin/institution/components/presentationals/admin-institution-form/admin-institution-form.presentational";
import {AdminInstitutionCreateRoutable} from "@admin/institution/components/routables/admin-institution-create/admin-institution-create.routable";
import {AdminInstitutionDetailEditRoutable} from "@admin/institution/components/routables/admin-institution-detail-edit/admin-institution-detail-edit.routable";
import {AdminInstitutionListRoutable} from "@admin/institution/components/routables/admin-institution-list/admin-institution-list.routable";
import {AdminInstitutionState} from "@admin/institution/stores/admin-institution.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminInstitutionListRoutable,
  AdminInstitutionDetailEditRoutable,
  AdminInstitutionCreateRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminInstitutionFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminInstitutionRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminInstitutionState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminInstitutionModule {
}
