import {AdminInstitutionCreateRoutable} from "@admin/institution/components/routables/admin-institution-create/admin-institution-create.routable";
import {AdminInstitutionDetailEditRoutable} from "@admin/institution/components/routables/admin-institution-detail-edit/admin-institution-detail-edit.routable";
import {AdminInstitutionListRoutable} from "@admin/institution/components/routables/admin-institution-list/admin-institution-list.routable";
import {AdminInstitutionState} from "@admin/institution/stores/admin-institution.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminInstitutionListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.institutionDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminInstitutionDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminInstitutionState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.institutionEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
  {
    path: AdminRoutesEnum.institutionCreate,
    component: AdminInstitutionCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminInstitutionRoutingModule {
}
