import {AdminIndexFieldAliasAction, adminIndexFieldAliasActionNameSpace} from "@admin/index-field-alias/stores/admin-index-field-alias.action";
import {Injectable} from "@angular/core";
import {IndexFieldAlias} from "@models";
import {
  Action,
  Actions,
  Selector,
  State, StateContext,
  Store,
} from "@ngxs/store";
import {DataManagementResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {
  ApiService,
  defaultResourceStateInitValue,
  isNullOrUndefined,
  MARK_AS_TRANSLATABLE,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
  urlSeparator,
} from "solidify-frontend";
import {AdminLanguageAction} from "@admin/language/stores/admin-language.action";
import {DepositStateModel} from "@deposit/stores/deposit.state";
import {Observable} from "rxjs";
import {AppSystemPropertyStateModel} from "@app/stores/system-property/app-system-property.state";
import {AppSystemPropertyAction} from "@app/stores/system-property/app-system-property.action";

export interface AdminIndexFieldAliasStateModel extends ResourceStateModel<IndexFieldAlias> {
}

@Injectable()
@State<AdminIndexFieldAliasStateModel>({
  name: LocalStateEnum.admin_indexFieldAlias,
  defaults: {
    ...defaultResourceStateInitValue(),
  },
  children: [],
})
export class AdminIndexFieldAliasState extends ResourceState<AdminIndexFieldAliasStateModel, IndexFieldAlias> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminIndexFieldAliasActionNameSpace,
      routeRedirectUrlAfterSuccessCreateAction: (resId: string) => RoutesEnum.adminIndexFieldAliasDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessUpdateAction: (resId: string) => RoutesEnum.adminIndexFieldAliasDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessDeleteAction: RoutesEnum.adminIndexFieldAlias,
      notificationResourceCreateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.index-field-alias.notification.resource.create"),
      notificationResourceDeleteSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.index-field-alias.notification.resource.delete"),
      notificationResourceUpdateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.index-field-alias.notification.resource.update"),
    });
  }

  protected get _urlResource(): string {
    return DataManagementResourceApiEnum.indexFieldAliases;
  }

  @Selector()
  static isLoading(state: AdminIndexFieldAliasStateModel): boolean {
    return StoreUtil.isLoadingState(state);
  }

  @Selector()
  static isLoadingWithDependency(state: AdminIndexFieldAliasStateModel): boolean {
    return this.isLoading(state);
  }

  @Selector()
  static currentTitle(state: AdminIndexFieldAliasStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.alias;
  }

  @Selector()
  static isReadyToBeDisplayed(state: AdminIndexFieldAliasStateModel): boolean {
    return this.isReadyToBeDisplayedInCreateMode
      && !isNullOrUndefined(state.current);
  }

  @Selector()
  static isReadyToBeDisplayedInCreateMode(state: AdminIndexFieldAliasStateModel): boolean {
    return true;
  }

  @Action([AdminIndexFieldAliasAction.UpdateSuccess, AdminIndexFieldAliasAction.CreateSuccess, AdminIndexFieldAliasAction.DeleteSuccess])
  refreshSystemProperties(ctx: StateContext<AppSystemPropertyStateModel>): Observable<any> {
    return ctx.dispatch(new AppSystemPropertyAction.GetSystemProperties());
  }
}
