import {adminIndexFieldAliasActionNameSpace} from "@admin/index-field-alias/stores/admin-index-field-alias.action";
import {
  AdminIndexFieldAliasState,
  AdminIndexFieldAliasStateModel,
} from "@admin/index-field-alias/stores/admin-index-field-alias.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {IndexFieldAlias, Language} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedIndexFieldAliasActionNameSpace} from "@shared/stores/index-field-alias/shared-index-field-alias.action";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";
import {SharedLanguageState} from "@shared/stores/language/shared-language.state";

@Component({
  selector: "dlcm-admin-index-field-alias-detail-edit-routable",
  templateUrl: "./admin-index-field-alias-detail-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminIndexFieldAliasDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<IndexFieldAlias, AdminIndexFieldAliasStateModel> {
  @Select(AdminIndexFieldAliasState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminIndexFieldAliasState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;

  languagesObs: Observable<Language[]> = MemoizedUtil.list(this._store, SharedLanguageState);

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedIndexFieldAliasActionNameSpace;

  readonly KEY_PARAM_NAME: keyof IndexFieldAlias & string = "alias";

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.admin_indexFieldAlias, adminIndexFieldAliasActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
