import {adminIndexFieldAliasActionNameSpace} from "@admin/index-field-alias/stores/admin-index-field-alias.action";
import {
  AdminIndexFieldAliasState,
  AdminIndexFieldAliasStateModel,
} from "@admin/index-field-alias/stores/admin-index-field-alias.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {
  IndexFieldAlias, Language,
  OrganizationalUnit,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedIndexFieldAliasActionNameSpace} from "@shared/stores/index-field-alias/shared-index-field-alias.action";
import {SharedOrganizationalUnitState} from "@shared/stores/organizational-unit/shared-organizational-unit.state";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";
import {SharedLanguageState} from "@shared/stores/language/shared-language.state";

@Component({
  selector: "dlcm-admin-index-field-alias-create-routable",
  templateUrl: "./admin-index-field-alias-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminIndexFieldAliasCreateRoutable extends SharedAbstractCreateRoutable<IndexFieldAlias, AdminIndexFieldAliasStateModel> {
  @Select(AdminIndexFieldAliasState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminIndexFieldAliasState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;
  listOrgUnitsObs: Observable<OrganizationalUnit[]> = MemoizedUtil.list(this._store, SharedOrganizationalUnitState);
  languagesObs: Observable<Language[]> = MemoizedUtil.list(this._store, SharedLanguageState);

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedIndexFieldAliasActionNameSpace;

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.admin_indexFieldAlias, adminIndexFieldAliasActionNameSpace, LocalStateEnum.admin);
  }

}
