import {AdminIndexFieldAliasRoutingModule} from "@admin/index-field-alias/admin-index-field-alias-routing.module";
import {AdminIndexFieldAliasFormPresentational} from "@admin/index-field-alias/components/presentationals/admin-index-field-alias-form/admin-index-field-alias-form.presentational";
import {AdminIndexFieldAliasCreateRoutable} from "@admin/index-field-alias/components/routables/admin-index-field-alias-create/admin-index-field-alias-create.routable";
import {AdminIndexFieldAliasDetailEditRoutable} from "@admin/index-field-alias/components/routables/admin-index-field-alias-detail-edit/admin-index-field-alias-detail-edit.routable";
import {AdminIndexFieldAliasListRoutable} from "@admin/index-field-alias/components/routables/admin-index-field-alias-list/admin-index-field-alias-list.routable";
import {AdminIndexFieldAliasState} from "@admin/index-field-alias/stores/admin-index-field-alias.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminIndexFieldAliasListRoutable,
  AdminIndexFieldAliasDetailEditRoutable,
  AdminIndexFieldAliasCreateRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminIndexFieldAliasFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminIndexFieldAliasRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminIndexFieldAliasState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminIndexFieldAliasModule {
}
