import {AdminIndexFieldAliasCreateRoutable} from "@admin/index-field-alias/components/routables/admin-index-field-alias-create/admin-index-field-alias-create.routable";
import {AdminIndexFieldAliasDetailEditRoutable} from "@admin/index-field-alias/components/routables/admin-index-field-alias-detail-edit/admin-index-field-alias-detail-edit.routable";
import {AdminIndexFieldAliasListRoutable} from "@admin/index-field-alias/components/routables/admin-index-field-alias-list/admin-index-field-alias-list.routable";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";
import {AdminIndexFieldAliasState} from "./stores/admin-index-field-alias.state";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminIndexFieldAliasListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.indexFieldAliasDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminIndexFieldAliasDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminIndexFieldAliasState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.indexFieldAliasEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
  {
    component: AdminIndexFieldAliasCreateRoutable,
    path: AdminRoutesEnum.indexFieldAliasCreate,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminIndexFieldAliasRoutingModule {
}
