import {adminFundingAgenciesOrgUnitActionNameSpace} from "@admin/funding-agencies/stores/organizational-unit/admin-organizational-unit-preservation-policy.action";
import {Injectable} from "@angular/core";
import {OrganizationalUnit} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  AssociationState,
  AssociationStateModel,
  defaultAssociationStateInitValue,
  NotificationService,
} from "solidify-frontend";

export interface AdminFundingAgenciesOrganizationalUnitStateModel extends AssociationStateModel<OrganizationalUnit> {
}

@Injectable()
@State<AdminFundingAgenciesOrganizationalUnitStateModel>({
  name: LocalStateEnum.admin_fundingAgencies_organizationalUnit,
  defaults: {
    ...defaultAssociationStateInitValue(),
  },
})
export class AdminFundingAgenciesOrganizationalUnitState extends AssociationState<AdminFundingAgenciesOrganizationalUnitStateModel, OrganizationalUnit> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminFundingAgenciesOrgUnitActionNameSpace,
      resourceName: ApiResourceNameEnum.ORG_UNIT,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.fundingAgencies;
  }
}
