import {adminFundingAgenciesActionNameSpace} from "@admin/funding-agencies/stores/admin-funding-agencies.action";
import {
  AdminFundingAgenciesState,
  AdminFundingAgenciesStateModel,
} from "@admin/funding-agencies/stores/admin-funding-agencies.state";
import {AdminFundingAgenciesOrgUnitAction} from "@admin/funding-agencies/stores/organizational-unit/admin-organizational-unit-preservation-policy.action";
import {AdminFundingAgenciesOrganizationalUnitState} from "@admin/funding-agencies/stores/organizational-unit/admin-organizational-unit-preservation-policy.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  FundingAgency,
  OrganizationalUnit,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedFundingAgencyActionNameSpace} from "@shared/stores/funding-agency/shared-funding-agency.action";
import {SharedOrganizationalUnitState} from "@shared/stores/organizational-unit/shared-organizational-unit.state";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-funding-agency-detail-edit-routable",
  templateUrl: "./admin-funding-agencies-detail-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminFundingAgenciesDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<FundingAgency, AdminFundingAgenciesStateModel> {
  @Select(AdminFundingAgenciesState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminFundingAgenciesState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;
  listOrgUnitsObs: Observable<OrganizationalUnit[]> = MemoizedUtil.list(this._store, SharedOrganizationalUnitState);
  selectedOrgUnitsObs: Observable<OrganizationalUnit[]> = MemoizedUtil.selected(this._store, AdminFundingAgenciesOrganizationalUnitState);

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedFundingAgencyActionNameSpace;

  readonly KEY_PARAM_NAME: keyof FundingAgency & string = "name";

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.admin_fundingAgencies, adminFundingAgenciesActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
    this._store.dispatch(new AdminFundingAgenciesOrgUnitAction.GetAll(id));
  }
}
