import {AdminFundingAgenciesRoutingModule} from "@admin/funding-agencies/admin-funding-agencies-routing.module";
import {AdminFundingAgenciesFormPresentational} from "@admin/funding-agencies/components/presentationals/admin-funding-agencies-form/admin-funding-agencies-form.presentational";
import {AdminFundingAgenciesCreateRoutable} from "@admin/funding-agencies/components/routables/admin-funding-agencies-create/admin-funding-agencies-create.routable";
import {AdminFundingAgenciesDetailEditRoutable} from "@admin/funding-agencies/components/routables/admin-funding-agencies-detail-edit/admin-funding-agencies-detail-edit.routable";
import {AdminFundingAgenciesListRoutable} from "@admin/funding-agencies/components/routables/admin-funding-agencies-list/admin-funding-agencies-list.routable";
import {AdminFundingAgenciesState} from "@admin/funding-agencies/stores/admin-funding-agencies.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminFundingAgenciesListRoutable,
  AdminFundingAgenciesDetailEditRoutable,
  AdminFundingAgenciesCreateRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminFundingAgenciesFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminFundingAgenciesRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminFundingAgenciesState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminFundingAgenciesModule {
}
