import {AdminFundingAgenciesCreateRoutable} from "@admin/funding-agencies/components/routables/admin-funding-agencies-create/admin-funding-agencies-create.routable";
import {AdminFundingAgenciesDetailEditRoutable} from "@admin/funding-agencies/components/routables/admin-funding-agencies-detail-edit/admin-funding-agencies-detail-edit.routable";
import {AdminFundingAgenciesListRoutable} from "@admin/funding-agencies/components/routables/admin-funding-agencies-list/admin-funding-agencies-list.routable";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";
import {AdminFundingAgenciesState} from "./stores/admin-funding-agencies.state";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminFundingAgenciesListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.fundingAgenciesDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminFundingAgenciesDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminFundingAgenciesState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.fundingAgenciesEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
  {
    component: AdminFundingAgenciesCreateRoutable,
    path: AdminRoutesEnum.fundingAgenciesCreate,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminFundingAgenciesRoutingModule {
}
