import {Injectable} from "@angular/core";
import {DisseminationPolicy} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {
  ApiService,
  defaultResourceStateInitValue,
  isNullOrUndefined,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
  MARK_AS_TRANSLATABLE,
  urlSeparator,
} from "solidify-frontend";
import {adminDisseminationPolicyActionNameSpace} from "./admin-dissemination-policy.action";

export interface AdminDisseminationPolicyStateModel extends ResourceStateModel<DisseminationPolicy> {
}

@Injectable()
@State<AdminDisseminationPolicyStateModel>({
  name: LocalStateEnum.admin_disseminationPolicy,
  defaults: {
    ...defaultResourceStateInitValue(),
  },
})
export class AdminDisseminationPolicyState extends ResourceState<AdminDisseminationPolicyStateModel, DisseminationPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminDisseminationPolicyActionNameSpace,
      routeRedirectUrlAfterSuccessCreateAction: (resId: string) => RoutesEnum.adminDisseminationPolicyDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessUpdateAction: (resId: string) => RoutesEnum.adminDisseminationPolicyDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessDeleteAction: RoutesEnum.adminDisseminationPolicy,
      notificationResourceCreateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.disseminationPolicy.notification.resource.create"),
      notificationResourceDeleteSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.disseminationPolicy.notification.resource.delete"),
      notificationResourceUpdateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.disseminationPolicy.notification.resource.update"),
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.disseminationPolicies;
  }

  @Selector()
  static isLoading(state: AdminDisseminationPolicyStateModel): boolean {
    return StoreUtil.isLoadingState(state);
  }

  @Selector()
  static isLoadingWithDependency(state: AdminDisseminationPolicyStateModel): boolean {
    return this.isLoading(state);
  }

  @Selector()
  static currentTitle(state: AdminDisseminationPolicyStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.name;
  }

  @Selector()
  static isReadyToBeDisplayed(state: AdminDisseminationPolicyStateModel): boolean {
    return this.isReadyToBeDisplayedInCreateMode
      && !isNullOrUndefined(state.current);
  }

  @Selector()
  static isReadyToBeDisplayedInCreateMode(state: AdminDisseminationPolicyStateModel): boolean {
    return true;
  }
}
