import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
} from "@angular/core";
import {
  FormBuilder,
  Validators,
} from "@angular/forms";
import {Enums} from "@enums";
import {DisseminationPolicy} from "@models";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {
  EnumUtil,
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-dissemination-policy-form",
  templateUrl: "./admin-dissemination-policy-form.presentational.html",
  styleUrls: ["../../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminDisseminationPolicyFormPresentational extends SharedAbstractFormPresentational<DisseminationPolicy> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  disseminationPolicyTypeEnum: Enums.DisseminationPolicy.TypeEnum[] = EnumUtil.convertToArray(Enums.DisseminationPolicy.TypeEnum);

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef, _elementRef);
  }

  protected bindFormTo(disseminationPolicies: DisseminationPolicy): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: [disseminationPolicies.name, [Validators.required, SolidifyValidator]],
      [this.formDefinition.destinationServer]: [disseminationPolicies.destinationServer, [SolidifyValidator]],
      [this.formDefinition.subFolder]: [disseminationPolicies.subFolder, [SolidifyValidator]],
      [this.formDefinition.type]: [disseminationPolicies.type, [SolidifyValidator]],
    });
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.destinationServer]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.subFolder]: ["", [SolidifyValidator]],
      [this.formDefinition.type]: ["", [Validators.required, SolidifyValidator]],
    });
  }

  protected treatmentBeforeSubmit(disseminationPolicies: DisseminationPolicy): DisseminationPolicy {
    return disseminationPolicies;
  }

}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() name: string;
  @PropertyName() destinationServer: string;
  @PropertyName() subFolder: string;
  @PropertyName() type: string;
}
