import {AdminDisseminationPolicyRoutingModule} from "@admin/dissemination-policy/admin-dissemination-policy-routing.module";
import {AdminDisseminationPolicyFormPresentational} from "@admin/dissemination-policy/components/presentationals/admin-dissemination-policy-form/admin-dissemination-policy-form.presentational";
import {AdminDisseminationPolicyCreateRoutable} from "@admin/dissemination-policy/components/routables/admin-dissemination-policy-create/admin-dissemination-policy-create.routable";
import {AdminDisseminationPolicyDetailEditRoutable} from "@admin/dissemination-policy/components/routables/admin-dissemination-policy-detail-edit/admin-dissemination-policy-detail-edit.routable";
import {AdminDisseminationPolicyListRoutable} from "@admin/dissemination-policy/components/routables/admin-dissemination-policy-list/admin-dissemination-policy-list.routable";
import {AdminDisseminationPolicyState} from "@admin/dissemination-policy/stores/admin-dissemination-policy.state";
import {NgModule} from "@angular/core";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {SharedModule} from "@shared/shared.module";

const routables = [
  AdminDisseminationPolicyListRoutable,
  AdminDisseminationPolicyDetailEditRoutable,
  AdminDisseminationPolicyCreateRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminDisseminationPolicyFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminDisseminationPolicyRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminDisseminationPolicyState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminDisseminationPolicyModule {
}
