import {AdminDisseminationPolicyCreateRoutable} from "@admin/dissemination-policy/components/routables/admin-dissemination-policy-create/admin-dissemination-policy-create.routable";
import {AdminDisseminationPolicyDetailEditRoutable} from "@admin/dissemination-policy/components/routables/admin-dissemination-policy-detail-edit/admin-dissemination-policy-detail-edit.routable";
import {AdminDisseminationPolicyListRoutable} from "@admin/dissemination-policy/components/routables/admin-dissemination-policy-list/admin-dissemination-policy-list.routable";
import {AdminDisseminationPolicyState} from "@admin/dissemination-policy/stores/admin-dissemination-policy.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminDisseminationPolicyListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.disseminationPolicyCreate,
    component: AdminDisseminationPolicyCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.disseminationPolicyDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminDisseminationPolicyDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminDisseminationPolicyState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.disseminationPolicyEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminDisseminationPolicyRoutingModule {
}
