import {
  ChangeDetectionStrategy,
  Component,
} from "@angular/core";
import {ApplicationRolePermissionEnum} from "@app/shared/enums/application-role-permission.enum";
import {RoutesEnum} from "@app/shared/enums/routes.enum";
import {TranslateService} from "@ngx-translate/core";
import {Store} from "@ngxs/store";
import {
  SharedAbstractHomeRoutable,
  SharedHomeTileModel,
} from "@shared/components/routables/shared-abstract-home/shared-abstract-home.routable";
import {DataTestEnum} from "@shared/enums/data-test.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {MARK_AS_TRANSLATABLE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-home-routable",
  templateUrl: "./admin-home.routable.html",
  styleUrls: ["./admin-home.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminHomeRoutable extends SharedAbstractHomeRoutable {
  _tiles: SharedHomeTileModel[] = [
    {
      avatarIcon: IconNameEnum.organizationalUnit,
      titleToTranslate: LabelTranslateEnum.organizationalUnits,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.organizationalUnit.home.subtitle"),
      path: RoutesEnum.adminOrganizationalUnit,
      permission: ApplicationRolePermissionEnum.noPermission,
      dataTest: DataTestEnum.adminTileOrganizationalUnit,
    },
    {
      avatarIcon: IconNameEnum.submissionPolicies,
      titleToTranslate: LabelTranslateEnum.submissionPolicies,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.submissionPolicy.home.subtitle"),
      path: RoutesEnum.adminSubmissionPolicy,
      permission: ApplicationRolePermissionEnum.noPermission,
      dataTest: DataTestEnum.adminTileSubmissionPolicy,
    },
    {
      avatarIcon: IconNameEnum.preservationPolicies,
      titleToTranslate: LabelTranslateEnum.preservationPolicies,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.preservationPolicy.home.subtitle"),
      path: RoutesEnum.adminPreservationPolicy,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.disseminationPolicies,
      titleToTranslate: LabelTranslateEnum.disseminationPolicies,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.disseminationPolicy.home.subtitle"),
      path: RoutesEnum.adminDisseminationPolicy,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.licenses,
      titleToTranslate: LabelTranslateEnum.licenses,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.license.home.subtitle"),
      path: RoutesEnum.adminLicense,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.institutions,
      titleToTranslate: LabelTranslateEnum.institutions,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.institution.home.subtitle"),
      path: RoutesEnum.adminInstitution,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.researchDomains,
      titleToTranslate: LabelTranslateEnum.researchAreas,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.researchDomain.home.subtitle"),
      path: RoutesEnum.adminResearchDomain,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.users,
      titleToTranslate: LabelTranslateEnum.users,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.user.home.subtitle"),
      path: RoutesEnum.adminUser,
      permission: ApplicationRolePermissionEnum.rootPermission,
      dataTest: DataTestEnum.adminTileUsers,
    },
    {
      avatarIcon: IconNameEnum.roles,
      titleToTranslate: LabelTranslateEnum.roles,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.roles.home.subtitle"),
      path: RoutesEnum.adminRole,
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
    {
      avatarIcon: IconNameEnum.oaiSets,
      titleToTranslate: LabelTranslateEnum.oaiSets,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.oai-set.home.subtitle"),
      path: RoutesEnum.adminOaiSet,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.oauth2Clients,
      titleToTranslate: LabelTranslateEnum.oAuth2Clients,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.oauth2.home.subtitle"),
      path: RoutesEnum.adminOAuth2client,
      permission: ApplicationRolePermissionEnum.rootPermission,
      dataTest: DataTestEnum.adminTileOauth2,
    },
    {
      avatarIcon: IconNameEnum.peoples,
      titleToTranslate: LabelTranslateEnum.people,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.person.home.subtitle"),
      path: RoutesEnum.adminPerson,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.fundingAgencies,
      titleToTranslate: LabelTranslateEnum.fundingAgencies,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.funding-agencies.home.subtitle"),
      path: RoutesEnum.adminFundingAgencies,
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
    {
      avatarIcon: IconNameEnum.indexFieldAliases,
      titleToTranslate: LabelTranslateEnum.indexFieldAliases,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.index-field-aliases.home.subtitle"),
      path: RoutesEnum.adminIndexFieldAlias,
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
    {
      avatarIcon: IconNameEnum.archiveAcl,
      titleToTranslate: LabelTranslateEnum.archiveAcl,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.archive-acl.home.subtitle"),
      path: RoutesEnum.adminArchiveAcl,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.languages,
      titleToTranslate: LabelTranslateEnum.languages,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.language.home.subtitle"),
      path: RoutesEnum.adminLanguage,
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
    {
      avatarIcon: IconNameEnum.metadataTypes,
      titleToTranslate: LabelTranslateEnum.metadataTypes,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.metadataType.home.subtitle"),
      path: RoutesEnum.adminMetadataType,
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    {
      avatarIcon: IconNameEnum.notifications,
      titleToTranslate: LabelTranslateEnum.notifications,
      subtitleToTranslate: MARK_AS_TRANSLATABLE("admin.notifications.home.subtitle"),
      path: RoutesEnum.adminNotification,
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
  ];

  constructor(protected readonly _store: Store,
              protected readonly _translate: TranslateService) {
    super(_store, _translate);
  }
}

