import {adminArchiveAclActionNameSpace} from "@admin/archive-acl/stores/admin-archive-acl.action";
import {AdminArchiveAclStateModel} from "@admin/archive-acl/stores/admin-archive-acl.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {Archive} from "@home/models/archive.model";
import {
  ArchiveACL,
  OrganizationalUnit,
  User,
} from "@models";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {DataTableComponentEnum} from "@shared/enums/data-table-component.enum";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RouterExtService} from "@shared/services/router-ext.service";
import {sharedArchiveActionNameSpace} from "@shared/stores/archive/shared-archive.action";
import {
  PARAM_QUERY_SEARCH,
  SharedArchiveState,
} from "@shared/stores/archive/shared-archive.state";
import {sharedOrganizationalUnitActionNameSpace} from "@shared/stores/organizational-unit/shared-organizational-unit.action";
import {SharedOrganizationalUnitState} from "@shared/stores/organizational-unit/shared-organizational-unit.state";
import {sharedUserActionNameSpace} from "@shared/stores/user/shared-user.action";
import {SharedUserState} from "@shared/stores/user/shared-user.state";
import {
  OrderEnum,
  ResourceNameSpace,
  Sort,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-archive-acl-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminArchiveAclListRoutable extends SharedAbstractListRoutable<ArchiveACL, AdminArchiveAclStateModel> {
  readonly KEY_CREATE_BUTTON: string = LabelTranslateEnum.create;
  readonly KEY_BACK_BUTTON: string | undefined = LabelTranslateEnum.backToAdmin;
  readonly KEY_PARAM_NAME: keyof ArchiveACL & string = "aipId";

  sharedArchiveNameSpace: ResourceNameSpace = sharedArchiveActionNameSpace;
  sharedArchiveState: typeof SharedArchiveState = SharedArchiveState;

  sharedUserSort: Sort<User> = {
    field: "lastName",
    order: OrderEnum.ascending,
  };
  sharedUserNameSpace: ResourceNameSpace = sharedUserActionNameSpace;
  sharedUserState: typeof SharedUserState = SharedUserState;

  sharedOrganizationalUnitSort: Sort<OrganizationalUnit> = {
    field: "name",
    order: OrderEnum.ascending,
  };
  sharedOrganizationalUnitNameSpace: ResourceNameSpace = sharedOrganizationalUnitActionNameSpace;
  sharedOrganizationalUnitState: typeof SharedOrganizationalUnitState = SharedOrganizationalUnitState;

  constructor(protected readonly _store: Store,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _route: ActivatedRoute,
              protected readonly _routerExt: RouterExtService,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog) {
    super(_store, _changeDetector, _route, _routerExt, _actions$, _dialog, LocalStateEnum.admin_archiveAcl, adminArchiveAclActionNameSpace, {}, LocalStateEnum.admin);
  }

  conditionDisplayEditButton(model: ArchiveACL | undefined): boolean {
    return true;
  }

  conditionDisplayDeleteButton(model: ArchiveACL | undefined): boolean {
    return true;
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "aipId",
        header: LabelTranslateEnum.archive,
        type: FieldTypeEnum.searchableSingleSelect,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
        resourceNameSpace: this.sharedArchiveNameSpace,
        resourceState: this.sharedArchiveState as any,
        resourceLabelCallback: (value: Archive) => value.title,
        resourceLabelKey: PARAM_QUERY_SEARCH,
        component: DataTableComponentEnum.archive,
      },
      {
        field: "user.person.fullName",
        header: LabelTranslateEnum.user,
        type: FieldTypeEnum.searchableSingleSelect,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
        resourceNameSpace: this.sharedUserNameSpace,
        resourceState: this.sharedUserState as any,
        resourceLabelKey: "lastName",
        resourceLabelCallback: (value: User) => value.lastName + ", " + value.firstName,
        searchableSingleSelectSort: this.sharedUserSort,
        filterableField: "user.resId",
        sortableField: "user.resId",
      },
      {
        field: "organizationalUnit.name",
        header: LabelTranslateEnum.organizationalUnit,
        type: FieldTypeEnum.searchableSingleSelect,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
        resourceNameSpace: this.sharedOrganizationalUnitNameSpace,
        resourceState: this.sharedOrganizationalUnitState as any,
        resourceLabelKey: "name",
        searchableSingleSelectSort: this.sharedOrganizationalUnitSort,
        filterableField: "organizationalUnit.resId" as any,
        sortableField: "organizationalUnit.resId" as any,
      },
      {
        field: "expiration",
        header: LabelTranslateEnum.expiration,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "creation.when" as any,
        header: LabelTranslateEnum.created,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "lastUpdate.when" as any,
        header: LabelTranslateEnum.updated,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.descending,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
