import {AdminArchiveAclRoutingModule} from "@admin/archive-acl/admin-archive-acl-routing.module";
import {AdminArchiveAclFormPresentational} from "@admin/archive-acl/components/presentationals/admin-archive-acl-form/admin-archive-acl-form.presentational";
import {AdminArchiveAclCreateRoutable} from "@admin/archive-acl/components/routables/admin-archive-acl-create/admin-archive-acl-create.routable";
import {AdminArchiveAclDetailEditRoutable} from "@admin/archive-acl/components/routables/admin-archive-acl-detail-edit/admin-archive-acl-detail-edit.routable";
import {AdminArchiveAclListRoutable} from "@admin/archive-acl/components/routables/admin-archive-acl-list/admin-archive-acl-list.routable";
import {AdminArchiveAclState} from "@admin/archive-acl/stores/admin-archive-acl.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminArchiveAclListRoutable,
  AdminArchiveAclDetailEditRoutable,
  AdminArchiveAclCreateRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminArchiveAclFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminArchiveAclRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminArchiveAclState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminArchiveAclModule {
}
