import {AdminArchiveAclCreateRoutable} from "@admin/archive-acl/components/routables/admin-archive-acl-create/admin-archive-acl-create.routable";
import {AdminArchiveAclDetailEditRoutable} from "@admin/archive-acl/components/routables/admin-archive-acl-detail-edit/admin-archive-acl-detail-edit.routable";
import {AdminArchiveAclListRoutable} from "@admin/archive-acl/components/routables/admin-archive-acl-list/admin-archive-acl-list.routable";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";
import {AdminArchiveAclState} from "./stores/admin-archive-acl.state";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminArchiveAclListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.archiveAclDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminArchiveAclDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminArchiveAclState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.archiveAclEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
  {
    component: AdminArchiveAclCreateRoutable,
    path: AdminRoutesEnum.archiveAclCreate,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminArchiveAclRoutingModule {
}
