import {AdminArchiveAclState} from "@admin/archive-acl/stores/admin-archive-acl.state";
import {AdminDisseminationPolicyState} from "@admin/dissemination-policy/stores/admin-dissemination-policy.state";
import {AdminFundingAgenciesState} from "@admin/funding-agencies/stores/admin-funding-agencies.state";
import {AdminFundingAgenciesOrganizationalUnitState} from "@admin/funding-agencies/stores/organizational-unit/admin-organizational-unit-preservation-policy.state";
import {AdminIndexFieldAliasState} from "@admin/index-field-alias/stores/admin-index-field-alias.state";
import {AdminInstitutionState} from "@admin/institution/stores/admin-institution.state";
import {AdminLanguageState} from "@admin/language/stores/admin-language.state";
import {AdminLicenseState} from "@admin/license/stores/admin-license.state";
import {AdminMetadataTypeState} from "@admin/metadata-type/stores/admin-metadata-type.state";
import {AdminNotificationState} from "@admin/notification/stores/admin-notification.state";
import {AdminNotificationStatusHistoryState} from "@admin/notification/stores/status-history/admin-notification-status-history.state";
import {AdminOaiSetState} from "@admin/oai-set/stores/admin-oai-set.state";
import {AdminOAuth2ClientState} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {AdminOrganizationalUnitAdditionalFieldsFormState} from "@admin/organizational-unit/stores/additional-fields-form/admin-organizational-unit-additional-fields-form.state";
import {AdminOrganizationalUnitState} from "@admin/organizational-unit/stores/admin-organizational-unit.state";
import {AdminOrganizationalUnitDisseminationPolicyState} from "@admin/organizational-unit/stores/dissemination-policy/admin-organizational-unit-dissemination-policy.state";
import {AdminOrganizationalUnitFundingAgencyState} from "@admin/organizational-unit/stores/funding-agency/admin-organizational-unit-funding-agency.state";
import {AdminOrganizationalUnitInstitutionState} from "@admin/organizational-unit/stores/institution/admin-organizational-unit-institution.state";
import {AdminOrganizationalUnitPersonRoleState} from "@admin/organizational-unit/stores/person-role/admin-organizational-unit-person-role.state";
import {AdminPersonState} from "@admin/person/stores/admin-person.state";
import {AdminPersonInstitutionsState} from "@admin/person/stores/institutions/admin-people-institutions.state";
import {AdminPersonOrgUnitRoleState} from "@admin/person/stores/person-role/admin-person-orgunit-role.state";
import {AdminPreservationPolicyState} from "@admin/preservation-policy/stores/admin-preservation-policy.state";
import {AdminResearchDomainState} from "@admin/research-domain/stores/admin-research-domain.state";
import {AdminRoleState} from "@admin/role/stores/admin-role.state";
import {AdminSubmissionPolicyState} from "@admin/submission-policy/stores/admin-submission-policy.state";
import {AdminUserState} from "@admin/user/stores/admin-user.state";
import {NgModule} from "@angular/core";
import {AdminRoutingModule} from "@app/features/admin/admin-routing.module";
import {AdminHomeRoutable} from "@app/features/admin/components/routables/admin-home/admin-home.routable";
import {AdminOrganizationalUnitPreservationPolicyState} from "@app/features/admin/organizational-unit/stores/preservation-policy/admin-organizational-unit-preservation-policy.state";
import {AdminOrganizationalUnitSubmissionPolicyState} from "@app/features/admin/organizational-unit/stores/submission-policy/admin-organizational-unit-submission-policy.state";
import {AdminState} from "@app/features/admin/stores/admin.state";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {ModuleLoadedEnum} from "@shared/enums/module-loaded.enum";

const routables = [
  AdminHomeRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminState,
      AdminSubmissionPolicyState,
      AdminPreservationPolicyState,
      AdminDisseminationPolicyState,
      AdminLicenseState,
      AdminInstitutionState,
      AdminOrganizationalUnitState,
      AdminOrganizationalUnitSubmissionPolicyState,
      AdminOrganizationalUnitPreservationPolicyState,
      AdminOrganizationalUnitDisseminationPolicyState,
      AdminOrganizationalUnitPersonRoleState,
      AdminOrganizationalUnitFundingAgencyState,
      AdminOrganizationalUnitInstitutionState,
      AdminOrganizationalUnitAdditionalFieldsFormState,
      AdminUserState,
      AdminOaiSetState,
      AdminOAuth2ClientState,
      AdminPersonState,
      AdminPersonOrgUnitRoleState,
      AdminRoleState,
      AdminNotificationState,
      AdminNotificationStatusHistoryState,
      AdminIndexFieldAliasState,
      AdminArchiveAclState,
      AdminFundingAgenciesState,
      AdminFundingAgenciesOrganizationalUnitState,
      AdminPersonInstitutionsState,
      AdminResearchDomainState,
      AdminLanguageState,
      AdminMetadataTypeState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminModule {
  constructor() {
    window[ModuleLoadedEnum.adminModuleLoaded] = true;
  }
}
