import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {AdminHomeRoutable} from "@app/features/admin/components/routables/admin-home/admin-home.routable";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@app/shared/enums/routes.enum";
import {ApplicationRoleGuardService} from "@app/shared/guards/application-role-guard.service";
import {ApplicationRolePermissionEnum} from "@shared/enums/application-role-permission.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminHomeRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.license,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./license/admin-license.module").then(m => m.AdminLicenseModule),
    data: {
      breadcrumb: LabelTranslateEnum.licenses,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.institution,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./institution/admin-institution.module").then(m => m.AdminInstitutionModule),
    data: {
      breadcrumb: LabelTranslateEnum.institutions,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.researchDomain,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./research-domain/admin-research-domain.module").then(m => m.AdminResearchDomainModule),
    data: {
      breadcrumb: LabelTranslateEnum.researchAreas,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.fundingAgencies,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./funding-agencies/admin-funding-agencies.module").then(m => m.AdminFundingAgenciesModule),
    data: {
      breadcrumb: LabelTranslateEnum.fundingAgencies,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.indexFieldAlias,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./index-field-alias/admin-index-field-alias.module").then(m => m.AdminIndexFieldAliasModule),
    data: {
      breadcrumb: LabelTranslateEnum.indexFieldAliases,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.archiveAcl,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./archive-acl/admin-archive-acl.module").then(m => m.AdminArchiveAclModule),
    data: {
      breadcrumb: LabelTranslateEnum.archiveAcl,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.oaiSet,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./oai-set/admin-oai-set.module").then(m => m.AdminOaiSetModule),
    data: {
      breadcrumb: LabelTranslateEnum.oaiSets,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.oauth2client,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./oauth2-client/admin-oauth2-client.module").then(m => m.AdminOauth2ClientModule),
    data: {
      breadcrumb: LabelTranslateEnum.oAuth2Clients,
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.organizationalUnit,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./organizational-unit/admin-organizational-unit.module").then(m => m.AdminOrganizationalUnitModule),
    data: {
      breadcrumb: LabelTranslateEnum.organizationalUnits,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.submissionPolicy,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./submission-policy/admin-submission-policy.module").then(m => m.AdminSubmissionPolicyModule),
    data: {
      breadcrumb: LabelTranslateEnum.submissionPolicies,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.person,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./person/admin-person.module").then(m => m.AdminPersonModule),
    data: {
      breadcrumb: LabelTranslateEnum.people,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.preservationPolicy,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./preservation-policy/admin-preservation-policy.module").then(m => m.AdminPreservationPolicyModule),
    data: {
      breadcrumb: LabelTranslateEnum.preservationPolicies,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.disseminationPolicy,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./dissemination-policy/admin-dissemination-policy.module").then(m => m.AdminDisseminationPolicyModule),
    data: {
      breadcrumb: LabelTranslateEnum.disseminationPolicies,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.role,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./role/admin-role.module").then(m => m.AdminRoleModule),
    data: {
      breadcrumb: LabelTranslateEnum.roles,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.notification,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./notification/admin-notification.module").then(m => m.AdminNotificationModule),
    data: {
      breadcrumb: LabelTranslateEnum.notifications,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.user,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./user/admin-user.module").then(m => m.AdminUserModule),
    data: {
      breadcrumb: LabelTranslateEnum.users,
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.language,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./language/admin-language.module").then(m => m.AdminLanguageModule),
    data: {
      breadcrumb: LabelTranslateEnum.languages,
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.metadataType,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./metadata-type/admin-metadata-type.module").then(m => m.AdminMetadataTypeModule),
    data: {
      breadcrumb: LabelTranslateEnum.metadataTypes,
    },
    canActivate: [ApplicationRoleGuardService],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminRoutingModule {
}
