/* tslint:disable */
import {Aip as AipPartial} from "@app/generated-api/model/aip.partial.model";
import {License as LicensePartial} from "@app/generated-api/model/license.partial.model";
import {MetadataType as MetadataTypePartial} from "@app/generated-api/model/metadata-type.partial.model";
import {Notification as NotificationPartial} from "@app/generated-api/model/notification.partial.model";
import {Oauth2Client as Oauth2ClientPartial} from "@app/generated-api/model/oauth2-client.partial.model";
import {Order as OrderPartial} from "@app/generated-api/model/order.partial.model";
import {PreservationJob as PreservationJobPartial} from "@app/generated-api/model/preservation-job.partial.model";
import {ColorHexaEnum} from "@shared/enums/color-hexa.enum";
import {KeyValueInfo} from "@shared/models/key-value-info.model";
import {StatusModel} from "@shared/models/status.model";
import {
  KeyValue,
  MARK_AS_TRANSLATABLE,
  StringUtil,
} from "solidify-frontend";
import {Deposit as DepositPartial} from "../generated-api/model/deposit.partial.model";
import {DisseminationPolicy as DisseminationPolicyPartial} from "../generated-api/model/dissemination-policy.partial.model";

export namespace Enums {
  export namespace Facet {
    export type Name =
      "creators"
      | "organizational-units"
      | "access-levels"
      | "format"
      | "data-tags";
    export const Name = {
      CREATORS: "creators" as Name,
      ORGANIZATIONAL_UNITS: "organizational-units" as Name,
      ACCESS_LEVELS: "access-levels" as Name,
      FORMAT: "format" as Name,
      DATA_TAGS: "data-tags" as Name,
    };
  }
  export namespace Aip {
    export type AipContainerEnum = AipPartial.ArchiveContainerEnum;
    export const AipContainerEnum = AipPartial.ArchiveContainerEnum;

    export type AipCopySearchTypeEnum =
      "ALL_COPIES"
      | "ALL_COPIES_COMPLETED"
      | "SOME_COPY_MISSING"
      | "SOME_COPY_IN_ERROR"
      | "SOME_COPY_MISC_STATUS";
    export const AipCopySearchTypeEnum = {
      ALL_COPIES: "ALL_COPIES" as AipCopySearchTypeEnum,
      ALL_COPIES_COMPLETED: "ALL_COPIES_COMPLETED" as AipCopySearchTypeEnum,
      SOME_COPY_MISSING: "SOME_COPY_MISSING" as AipCopySearchTypeEnum,
      SOME_COPY_IN_ERROR: "SOME_COPY_IN_ERROR" as AipCopySearchTypeEnum,
      SOME_COPY_MISC_STATUS: "SOME_COPY_MISC_STATUS" as AipCopySearchTypeEnum,
    };
    export const AipCopySearchTypeEnumTranslate: KeyValue[] = [
      {
        key: AipCopySearchTypeEnum.ALL_COPIES_COMPLETED,
        value: MARK_AS_TRANSLATABLE("ALL_COPIES_COMPLETED"),
      },
      {
        key: AipCopySearchTypeEnum.SOME_COPY_IN_ERROR,
        value: MARK_AS_TRANSLATABLE("SOME_COPY_IN_ERROR"),
      },
      {
        key: AipCopySearchTypeEnum.SOME_COPY_MISSING,
        value: MARK_AS_TRANSLATABLE("SOME_COPY_MISSING"),
      },
      {
        key: AipCopySearchTypeEnum.SOME_COPY_MISC_STATUS,
        value: MARK_AS_TRANSLATABLE("SOME_COPY_MISC_STATUS"),
      },
    ];
  }

  export namespace DataFile {
    export type DataCategoryEnum = "Primary"
      | "Secondary"
      | "Package"
      | "Software"
      | "Internal";
    export const DataCategoryEnum = {
      Primary: "Primary" as DataCategoryEnum,
      Secondary: "Secondary" as DataCategoryEnum,
      Package: "Package" as DataCategoryEnum,
      Software: "Software" as DataCategoryEnum,
      Internal: "Internal" as DataCategoryEnum,
    };
    export type DataTypeEnum = "Observational"
      | "Experimental"
      | "Simulation"
      | "Derived"
      | "Reference"
      | "Digitalized"
      | "Publication"
      | "DataPaper"
      | "Documentation"
      | "InformationPackage"
      | "Metadata"
      | "CustomMetadata"
      | "Code"
      | "Binaries"
      | "VirtualMachine"
      | "DatasetThumbnail"
      | "DatafileThumbnail";
    export const DataTypeEnum = {
      Observational: "Observational" as DataTypeEnum,
      Experimental: "Experimental" as DataTypeEnum,
      Simulation: "Simulation" as DataTypeEnum,
      Derived: "Derived" as DataTypeEnum,
      Reference: "Reference" as DataTypeEnum,
      Digitalized: "Digitalized" as DataTypeEnum,
      Publication: "Publication" as DataTypeEnum,
      DataPaper: "DataPaper" as DataTypeEnum,
      Documentation: "Documentation" as DataTypeEnum,
      InformationPackage: "InformationPackage" as DataTypeEnum,
      Metadata: "Metadata" as DataTypeEnum,
      CustomMetadata: "CustomMetadata" as DataTypeEnum,
      Code: "Code" as DataTypeEnum,
      Binaries: "Binaries" as DataTypeEnum,
      VirtualMachine: "VirtualMachine" as DataTypeEnum,
      DatasetThumbnail: "DatasetThumbnail" as DataTypeEnum,
      DatafileThumbnail: "DatafileThumbnail" as DataTypeEnum,
    };

    export type StatusEnum =
      "IN_ERROR"
      | "READY"
      | "RECEIVED"
      | "CHANGE_RELATIVE_LOCATION"
      | "TO_PROCESS"
      | "PROCESSED"
      | "FILE_FORMAT_IDENTIFIED"
      | "FILE_FORMAT_UNKNOWN"
      | "VIRUS_CHECKED"
      | "CLEANING"
      | "CLEANED"
      | "IGNORED_FILE"
      | "EXCLUDED_FILE";
    export const StatusEnum = {
      IN_ERROR: "IN_ERROR" as StatusEnum,
      READY: "READY" as StatusEnum,
      RECEIVED: "RECEIVED" as StatusEnum,
      CHANGE_RELATIVE_LOCATION: "CHANGE_RELATIVE_LOCATION" as StatusEnum,
      TO_PROCESS: "TO_PROCESS" as StatusEnum,
      PROCESSED: "PROCESSED" as StatusEnum,
      FILE_FORMAT_IDENTIFIED: "FILE_FORMAT_IDENTIFIED" as StatusEnum,
      FILE_FORMAT_UNKNOWN: "FILE_FORMAT_UNKNOWN" as StatusEnum,
      VIRUS_CHECKED: "VIRUS_CHECKED" as StatusEnum,
      CLEANING: "CLEANING" as StatusEnum,
      CLEANED: "CLEANED" as StatusEnum,
      IGNORED_FILE: "IGNORED_FILE" as StatusEnum,
      EXCLUDED_FILE: "EXCLUDED_FILE" as StatusEnum,
    };
    export const StatusEnumTranslate: StatusModel[] = [
      {
        key: StatusEnum.IN_ERROR,
        value: MARK_AS_TRANSLATABLE("IN_ERROR"),
        backgroundColorHexa: ColorHexaEnum.red,
      },
      {
        key: StatusEnum.READY,
        value: MARK_AS_TRANSLATABLE("READY"),
        backgroundColorHexa: ColorHexaEnum.green,
      },
      {
        key: StatusEnum.RECEIVED,
        value: MARK_AS_TRANSLATABLE("RECEIVED"),
      },
      {
        key: StatusEnum.CHANGE_RELATIVE_LOCATION,
        value: MARK_AS_TRANSLATABLE("CHANGE_RELATIVE_LOCATION"),
      },
      {
        key: StatusEnum.TO_PROCESS,
        value: MARK_AS_TRANSLATABLE("TO_PROCESS"),
      },
      {
        key: StatusEnum.PROCESSED,
        value: MARK_AS_TRANSLATABLE("PROCESSED"),
      },
      {
        key: StatusEnum.FILE_FORMAT_IDENTIFIED,
        value: MARK_AS_TRANSLATABLE("FILE_FORMAT_IDENTIFIED"),
      },
      {
        key: StatusEnum.FILE_FORMAT_UNKNOWN,
        value: MARK_AS_TRANSLATABLE("FILE_FORMAT_UNKNOWN"),
      },
      {
        key: StatusEnum.VIRUS_CHECKED,
        value: MARK_AS_TRANSLATABLE("VIRUS_CHECKED"),
      },
      {
        key: StatusEnum.CLEANING,
        value: MARK_AS_TRANSLATABLE("CLEANING"),
      },
      {
        key: StatusEnum.EXCLUDED_FILE,
        value: MARK_AS_TRANSLATABLE("EXCLUDED_FILE"),
        backgroundColorHexa: ColorHexaEnum.red,
      },
      {
        key: StatusEnum.IGNORED_FILE,
        value: MARK_AS_TRANSLATABLE("IGNORED_FILE"),
        backgroundColorHexa: ColorHexaEnum.orange,
      },
      {
        key: StatusEnum.CLEANED,
        value: MARK_AS_TRANSLATABLE("CLEANED"),
        backgroundColorHexa: ColorHexaEnum.green,
      },
    ];

    // TODO REFACTOR HERE TO MATCH WITH USUAL WAY
    export function getExplanation(status: StatusEnum): string {
      switch (status) {
        case StatusEnum.READY:
          return MARK_AS_TRANSLATABLE("dataFileQuickStatus.ready");
        case StatusEnum.IN_ERROR:
          return MARK_AS_TRANSLATABLE("dataFileQuickStatus.inError");
        case StatusEnum.EXCLUDED_FILE:
          return MARK_AS_TRANSLATABLE("dataFileQuickStatus.excludedFile");
        case StatusEnum.IGNORED_FILE:
          return MARK_AS_TRANSLATABLE("dataFileQuickStatus.ignoredFile");
        case StatusEnum.CLEANED:
          return MARK_AS_TRANSLATABLE("dataFileQuickStatus.cleaned");
        default:
          return MARK_AS_TRANSLATABLE("dataFileQuickStatus.pending");
      }
    }

    export type ComplianceLevelEnum =
      "NOT_ASSESSED"
      | "NO_COMPLIANCE"
      | "WEAK_COMPLIANCE"
      | "AVERAGE_COMPLIANCE"
      | "FULL_COMPLIANCE";
    export const ComplianceLevelEnum = {
      NOT_ASSESSED: "NOT_ASSESSED" as ComplianceLevelEnum,
      NO_COMPLIANCE: "NO_COMPLIANCE" as ComplianceLevelEnum,
      WEAK_COMPLIANCE: "WEAK_COMPLIANCE" as ComplianceLevelEnum,
      AVERAGE_COMPLIANCE: "AVERAGE_COMPLIANCE" as ComplianceLevelEnum,
      FULL_COMPLIANCE: "FULL_COMPLIANCE" as ComplianceLevelEnum,
    };
    export const ComplianceLevelEnumTranslate: KeyValue[] = [
      {
        key: ComplianceLevelEnum.FULL_COMPLIANCE,
        value: MARK_AS_TRANSLATABLE("FULL_COMPLIANCE"),
      },
      {
        key: ComplianceLevelEnum.AVERAGE_COMPLIANCE,
        value: MARK_AS_TRANSLATABLE("AVERAGE_COMPLIANCE"),
      },
      {
        key: ComplianceLevelEnum.WEAK_COMPLIANCE,
        value: MARK_AS_TRANSLATABLE("WEAK_COMPLIANCE"),
      },
      {
        key: ComplianceLevelEnum.NO_COMPLIANCE,
        value: MARK_AS_TRANSLATABLE("NO_COMPLIANCE"),
      },
      {
        key: ComplianceLevelEnum.NOT_ASSESSED,
        value: MARK_AS_TRANSLATABLE("NOT_ASSESSED"),
      },
    ];

    export enum ComplianceLevelNumberEnum {
      NOT_ASSESSED = 0,
      NO_COMPLIANCE = 1,
      WEAK_COMPLIANCE = 2,
      AVERAGE_COMPLIANCE = 3,
      FULL_COMPLIANCE = 4,
    }

    export class ConvertComplianceLevel {
      static convertStringToNumber(complianceLevelString: ComplianceLevelEnum): ComplianceLevelNumberEnum {
        switch (complianceLevelString) {
          case Enums.DataFile.ComplianceLevelEnum.NO_COMPLIANCE: {
            return Enums.DataFile.ComplianceLevelNumberEnum.NO_COMPLIANCE;
          }
          case Enums.DataFile.ComplianceLevelEnum.WEAK_COMPLIANCE: {
            return Enums.DataFile.ComplianceLevelNumberEnum.WEAK_COMPLIANCE;
          }
          case Enums.DataFile.ComplianceLevelEnum.AVERAGE_COMPLIANCE: {
            return Enums.DataFile.ComplianceLevelNumberEnum.AVERAGE_COMPLIANCE;
          }
          case Enums.DataFile.ComplianceLevelEnum.FULL_COMPLIANCE: {
            return Enums.DataFile.ComplianceLevelNumberEnum.FULL_COMPLIANCE;
          }
          case Enums.DataFile.ComplianceLevelEnum.NOT_ASSESSED:
          default:
            return Enums.DataFile.ComplianceLevelNumberEnum.NOT_ASSESSED;
        }
      }

      static convertNumberToString(complianceLevelString: ComplianceLevelNumberEnum): ComplianceLevelEnum {
        switch (complianceLevelString) {
          case Enums.DataFile.ComplianceLevelNumberEnum.NO_COMPLIANCE: {
            return Enums.DataFile.ComplianceLevelEnum.NO_COMPLIANCE;
          }
          case Enums.DataFile.ComplianceLevelNumberEnum.WEAK_COMPLIANCE: {
            return Enums.DataFile.ComplianceLevelEnum.WEAK_COMPLIANCE;
          }
          case Enums.DataFile.ComplianceLevelNumberEnum.AVERAGE_COMPLIANCE: {
            return Enums.DataFile.ComplianceLevelEnum.AVERAGE_COMPLIANCE;
          }
          case Enums.DataFile.ComplianceLevelNumberEnum.FULL_COMPLIANCE: {
            return Enums.DataFile.ComplianceLevelEnum.FULL_COMPLIANCE;
          }
          case Enums.DataFile.ComplianceLevelNumberEnum.NOT_ASSESSED:
          default:
            return Enums.DataFile.ComplianceLevelEnum.NOT_ASSESSED;
        }
      }
    }
  }

  export namespace Deposit {
    export type AccessEnum = DepositPartial.AccessEnum;
    export const AccessEnum = DepositPartial.AccessEnum;
    export const AccessEnumTranslate: KeyValue[] = [
      {
        key: AccessEnum.PUBLIC,
        value: MARK_AS_TRANSLATABLE("enum.access.public"),
      },
      {
        key: AccessEnum.RESTRICTED,
        value: MARK_AS_TRANSLATABLE("enum.access.restricted"),
      },
      {
        key: AccessEnum.CLOSED,
        value: MARK_AS_TRANSLATABLE("enum.access.closed"),
      },
    ];

    export type DataSensitivityEnum = DepositPartial.DataSensitivityEnum;
    export const DataSensitivityEnum = DepositPartial.DataSensitivityEnum;
    export const DataSensitivityEnumTranslate: KeyValueInfo[] = [
      {
        key: DataSensitivityEnum.UNDEFINED,
        value: MARK_AS_TRANSLATABLE("enum.dataSensitivity.undefined"),
      },
      {
        key: DataSensitivityEnum.BLUE,
        value: MARK_AS_TRANSLATABLE("enum.dataSensitivity.blue"),
        infoToTranslate: MARK_AS_TRANSLATABLE("enum.dataSensitivityInfo.blue"),
      },
      {
        key: DataSensitivityEnum.GREEN,
        value: MARK_AS_TRANSLATABLE("enum.dataSensitivity.green"),
        infoToTranslate: MARK_AS_TRANSLATABLE("enum.dataSensitivityInfo.green"),
      },
      {
        key: DataSensitivityEnum.YELLOW,
        value: MARK_AS_TRANSLATABLE("enum.dataSensitivity.yellow"),
        infoToTranslate: MARK_AS_TRANSLATABLE("enum.dataSensitivityInfo.yellow"),
      },
      {
        key: DataSensitivityEnum.ORANGE,
        value: MARK_AS_TRANSLATABLE("enum.dataSensitivity.orange"),
        infoToTranslate: MARK_AS_TRANSLATABLE("enum.dataSensitivityInfo.orange"),
      },
      {
        key: DataSensitivityEnum.RED,
        value: MARK_AS_TRANSLATABLE("enum.dataSensitivity.red"),
        infoToTranslate: MARK_AS_TRANSLATABLE("enum.dataSensitivityInfo.red"),
      },
      {
        key: DataSensitivityEnum.CRIMSON,
        value: MARK_AS_TRANSLATABLE("enum.dataSensitivity.crimson"),
        infoToTranslate: MARK_AS_TRANSLATABLE("enum.dataSensitivityInfo.crimson"),
      },
    ];

    export type MetadataVersionEnum = DepositPartial.MetadataVersionEnum;
    export const MetadataVersionEnum = DepositPartial.MetadataVersionEnum;

    export type StatusEnum = DepositPartial.StatusEnum;
    export const StatusEnum = DepositPartial.StatusEnum;
    export const StatusEnumTranslate: StatusModel[] = [
      {
        key: StatusEnum.INPROGRESS,
        value: MARK_AS_TRANSLATABLE("IN_PROGRESS"),
        backgroundColorHexa: ColorHexaEnum.orange,
      },
      {
        key: StatusEnum.INVALIDATION,
        value: MARK_AS_TRANSLATABLE("IN_VALIDATION"),
        backgroundColorHexa: ColorHexaEnum.blue,
      },
      {
        key: StatusEnum.REJECTED,
        value: MARK_AS_TRANSLATABLE("REJECTED"),
      },
      {
        key: StatusEnum.INERROR,
        value: MARK_AS_TRANSLATABLE("IN_ERROR"),
        backgroundColorHexa: ColorHexaEnum.red,
      },
      {
        key: StatusEnum.PAUSED,
        value: MARK_AS_TRANSLATABLE("PAUSED"),
      },
      {
        key: StatusEnum.CHECKED,
        value: MARK_AS_TRANSLATABLE("CHECKED"),
      },
      {
        key: StatusEnum.REJECTED,
        value: MARK_AS_TRANSLATABLE("REJECTED"),
      },
      {
        key: StatusEnum.APPROVED,
        value: MARK_AS_TRANSLATABLE("APPROVED"),
      },
      {
        key: StatusEnum.SUBMITTED,
        value: MARK_AS_TRANSLATABLE("SUBMITTED"),
      },
      {
        key: StatusEnum.COMPLETED,
        value: MARK_AS_TRANSLATABLE("COMPLETED"),
        backgroundColorHexa: ColorHexaEnum.green,
      },
      {
        key: StatusEnum.CLEANING,
        value: MARK_AS_TRANSLATABLE("CLEANING"),
      },
      {
        key: StatusEnum.CLEANED,
        value: MARK_AS_TRANSLATABLE("CLEANED"),
        backgroundColorHexa: ColorHexaEnum.green,
      },
    ];

    export const EmbargoAccessLevelEnum: KeyValue[] = AccessEnumTranslate;

    export function EmbargoAccessLevelEnumList(access: AccessEnum): KeyValue[] {
      if (access === AccessEnum.PUBLIC) {
        return [
          {
            key: AccessEnum.RESTRICTED,
            value: MARK_AS_TRANSLATABLE("enum.access.restricted"),
          },
          {
            key: AccessEnum.CLOSED,
            value: MARK_AS_TRANSLATABLE("enum.access.closed"),
          },
        ];
      } else if (access === AccessEnum.RESTRICTED) {
        return [
          {
            key: AccessEnum.CLOSED,
            value: MARK_AS_TRANSLATABLE("enum.access.closed"),
          },
        ];
      }
    }
  }

  export namespace DisseminationPolicy {
    export type TypeEnum = DisseminationPolicyPartial.TypeEnum;
    export const TypeEnum = DisseminationPolicyPartial.TypeEnum;
    export const TypeEnumTranslate: KeyValue[] = [
      {
        key: DisseminationPolicy.TypeEnum.WEB,
        value: "WEB",
      },
      {
        key: DisseminationPolicy.TypeEnum.IIIF,
        value: "IIIF",
      },
    ];
  }

  export namespace FormDescription {
    export type TypeEnum = "FORMLY";
    export const TypeEnum = {
      FORMLY: "FORMLY" as TypeEnum,
    };
    export const LanguageEnumTranslate: KeyValue[] = [
      {
        key: TypeEnum.FORMLY,
        value: MARK_AS_TRANSLATABLE("formDescription.typeEnum.formly"),
      },
    ];
  }

  export namespace Language {
    export type LanguageEnum =
      "fr"
      | "de"
      | "en";
    export const LanguageEnum = {
      fr: "fr" as LanguageEnum,
      de: "de" as LanguageEnum,
      en: "en" as LanguageEnum,
    };
    export const LanguageEnumTranslate: KeyValue[] = [
      {
        key: LanguageEnum.en,
        value: MARK_AS_TRANSLATABLE("language.english"),
      },
      {
        key: LanguageEnum.de,
        value: MARK_AS_TRANSLATABLE("language.german"),
      },
      {
        key: LanguageEnum.fr,
        value: MARK_AS_TRANSLATABLE("language.french"),
      },
    ];
  }

  export namespace License {
    export type OdConformanceEnum = LicensePartial.OdConformanceEnum;
    export const OdConformanceEnum = LicensePartial.OdConformanceEnum;
    export const OdConformanceEnumTranslate: KeyValue[] = [
      {
        key: License.OdConformanceEnum.Empty,
        value: StringUtil.stringEmpty,
      },
      {
        key: License.OdConformanceEnum.Approved,
        value: MARK_AS_TRANSLATABLE("enum.license.odConformance.approved"),
      },
      {
        key: License.OdConformanceEnum.NotReviewed,
        value: MARK_AS_TRANSLATABLE("enum.license.odConformance.notReviewed"),
      },
      {
        key: License.OdConformanceEnum.Rejected,
        value: MARK_AS_TRANSLATABLE("enum.license.odConformance.rejected"),
      },
    ];
    export type OsdConformanceEnum = LicensePartial.OsdConformanceEnum;
    export const OsdConformanceEnum = LicensePartial.OsdConformanceEnum;
    export const OsdConformanceEnumTranslate: KeyValue[] = [
      {
        key: License.OsdConformanceEnum.Empty,
        value: StringUtil.stringEmpty,
      },
      {
        key: License.OsdConformanceEnum.Approved,
        value: MARK_AS_TRANSLATABLE("enum.license.osdConformance.approved"),
      },
      {
        key: License.OsdConformanceEnum.NotReviewed,
        value: MARK_AS_TRANSLATABLE("enum.license.osdConformance.notReviewed"),
      },
      {
        key: License.OsdConformanceEnum.Rejected,
        value: MARK_AS_TRANSLATABLE("enum.license.osdConformance.rejected"),
      },
    ];
    export type StatusEnum = LicensePartial.StatusEnum;
    export const StatusEnum = LicensePartial.StatusEnum;
    export const StatusEnumTranslate: KeyValue[] = [
      {
        key: License.StatusEnum.Active,
        value: MARK_AS_TRANSLATABLE("enum.license.status.active"),
      },
      {
        key: License.StatusEnum.Superseded,
        value: MARK_AS_TRANSLATABLE("enum.license.status.superseded"),
      },
      {
        key: License.StatusEnum.Retired,
        value: MARK_AS_TRANSLATABLE("enum.license.status.retired"),
      },
    ];
  }

  export namespace MetadataType {
    export type MetadataFormatEnum = MetadataTypePartial.MetadataFormatEnum;
    export const MetadataFormatEnum = MetadataTypePartial.MetadataFormatEnum;
    export const MetadataFormatEnumTranslate: KeyValue[] = [
      {
        key: MetadataType.MetadataFormatEnum.SCHEMALESS,
        value: MARK_AS_TRANSLATABLE("enum.metadataFormatEnum.schemaless"),
      },
      {
        key: MetadataType.MetadataFormatEnum.JSON,
        value: MARK_AS_TRANSLATABLE("enum.metadataFormatEnum.json"),
      },
      {
        key: MetadataType.MetadataFormatEnum.XML,
        value: MARK_AS_TRANSLATABLE("enum.metadataFormatEnum.xml"),
      },
      {
        key: MetadataType.MetadataFormatEnum.CUSTOM,
        value: MARK_AS_TRANSLATABLE("enum.metadataFormatEnum.custom"),
      },
    ];
  }

  export namespace Notification {
    export type StatusEnum = NotificationPartial.NotificationStatusEnum;
    export const StatusEnum = NotificationPartial.NotificationStatusEnum;
    export const StatusEnumTranslate: StatusModel[] = [
      {
        key: StatusEnum.PROCESSED,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationStatus.processed"),
        backgroundColorHexa: ColorHexaEnum.green,
      },
      {
        key: StatusEnum.REFUSED,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationStatus.refused"),
        backgroundColorHexa: ColorHexaEnum.red,
      },
      {
        key: StatusEnum.PENDING,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationStatus.pending"),
        backgroundColorHexa: ColorHexaEnum.blue,
      },
    ];

    export type CategoryEnum =
      "INFO"
      | "REQUEST";
    export const CategoryEnum = {
      INFO: "INFO" as CategoryEnum,
      REQUEST: "REQUEST" as CategoryEnum,
    };
    export const CategoryEnumTranslate: KeyValue[] = [
      {
        key: CategoryEnum.REQUEST,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationCategory.request"),
      },
      {
        key: CategoryEnum.INFO,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationCategory.info"),
      },
    ];

    export type TypeEnum =
      "ACCESS_DATASET_REQUEST"
      | "JOIN_ORGUNIT_REQUEST"
      | "VALIDATE_DEPOSIT_REQUEST"
      | "CREATED_DEPOSIT_INFO"
      | "IN_ERROR_DEPOSIT_INFO"
      | "CREATE_ORGUNIT_REQUEST"
      | "IN_ERROR_SIP_INFO"
      | "IN_ERROR_AIP_INFO"
      | "IN_ERROR_DIP_INFO"
      | "IN_ERROR_DOWNLOADED_AIP_INFO"
      | "APPROVE_DISPOSAL_BY_ORGUNIT_REQUEST"
      | "APPROVE_DISPOSAL_REQUEST";
    export const TypeEnum = {
      ACCESS_DATASET_REQUEST: "ACCESS_DATASET_REQUEST" as TypeEnum,
      JOIN_ORGUNIT_REQUEST: "JOIN_ORGUNIT_REQUEST" as TypeEnum,
      VALIDATE_DEPOSIT_REQUEST: "VALIDATE_DEPOSIT_REQUEST" as TypeEnum,
      CREATED_DEPOSIT_INFO: "CREATED_DEPOSIT_INFO" as TypeEnum,
      IN_ERROR_DEPOSIT_INFO: "IN_ERROR_DEPOSIT_INFO" as TypeEnum,
      CREATE_ORGUNIT_REQUEST: "CREATE_ORGUNIT_REQUEST" as TypeEnum,
      IN_ERROR_SIP_INFO: "IN_ERROR_SIP_INFO" as TypeEnum,
      IN_ERROR_AIP_INFO: "IN_ERROR_AIP_INFO" as TypeEnum,
      IN_ERROR_DIP_INFO: "IN_ERROR_DIP_INFO" as TypeEnum,
      IN_ERROR_DOWNLOADED_AIP_INFO: "IN_ERROR_DOWNLOADED_AIP_INFO" as TypeEnum,
      APPROVE_DISPOSAL_BY_ORGUNIT_REQUEST: "APPROVE_DISPOSAL_BY_ORGUNIT_REQUEST" as TypeEnum,
      APPROVE_DISPOSAL_REQUEST: "APPROVE_DISPOSAL_REQUEST" as TypeEnum,
    };
    export const TypeEnumTranslate: KeyValue[] = [
      {
        key: TypeEnum.ACCESS_DATASET_REQUEST,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.accessDatasetRequest"),
      },
      {
        key: TypeEnum.JOIN_ORGUNIT_REQUEST,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.joinOrgUnitRequest"),
      },
      {
        key: TypeEnum.VALIDATE_DEPOSIT_REQUEST,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.validateDepositRequest"),
      },
      {
        key: TypeEnum.CREATED_DEPOSIT_INFO,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.createdDepositInfo"),
      },
      {
        key: TypeEnum.IN_ERROR_DEPOSIT_INFO,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.inErrorDepositInfo"),
      },
      {
        key: TypeEnum.CREATE_ORGUNIT_REQUEST,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.createOrgUnitRequest"),
      },
      {
        key: TypeEnum.IN_ERROR_SIP_INFO,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.inErrorSipInfo"),
      },
      {
        key: TypeEnum.IN_ERROR_AIP_INFO,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.inErrorAipInfo"),
      },
      {
        key: TypeEnum.IN_ERROR_DIP_INFO,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.inErrorDipInfo"),
      },
      {
        key: TypeEnum.IN_ERROR_DOWNLOADED_AIP_INFO,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.inErrorDownloadedAipInfo"),
      },
      {
        key: TypeEnum.APPROVE_DISPOSAL_BY_ORGUNIT_REQUEST,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.approveDisposalByOrgunitRequest"),
      },
      {
        key: TypeEnum.APPROVE_DISPOSAL_REQUEST,
        value: MARK_AS_TRANSLATABLE("notification.enum.notificationType.approveDisposalRequest"),
      },
    ];
  }

  export namespace Archive {
    export type RatingTypeEnum =
      "QUALITY"
      | "USEFULNESS";
    export const RatingTypeEnum = {
      QUALITY: "QUALITY" as RatingTypeEnum,
      USEFULNESS: "USEFULNESS" as RatingTypeEnum,
    };
    export const RatingTypeEnumTranslate: KeyValue[] = [
      {
        key: RatingTypeEnum.QUALITY,
        value: MARK_AS_TRANSLATABLE("home.archive.ranking.quality"),
      },
      {
        key: RatingTypeEnum.USEFULNESS,
        value: MARK_AS_TRANSLATABLE("home.archive.ranking.usefulness"),
      },
    ];
  }

  export namespace Oauth2Client {
    export type ScopeEnum = Oauth2ClientPartial.ScopeEnum;
    export const ScopeEnum = Oauth2ClientPartial.ScopeEnum;
  }

  export namespace Order {
    export type QueryTypeEnum = OrderPartial.QueryTypeEnum;
    export const QueryTypeEnum = OrderPartial.QueryTypeEnum;
    export const QueryTypeEnumTranslate: KeyValue[] = [
      {
        key: QueryTypeEnum.DIRECT,
        value: MARK_AS_TRANSLATABLE("enum.queryType.direct"),
      },
      {
        key: QueryTypeEnum.SIMPLE,
        value: MARK_AS_TRANSLATABLE("enum.queryType.simple"),
      },
      {
        key: QueryTypeEnum.ADVANCED,
        value: MARK_AS_TRANSLATABLE("enum.queryType.advanced"),
      },
    ];
    export type StatusEnum = OrderPartial.StatusEnum;
    export const StatusEnum = OrderPartial.StatusEnum;
    export const StatusEnumTranslate: StatusModel[] = [
      {
        key: StatusEnum.INERROR,
        value: MARK_AS_TRANSLATABLE("order.enum.status.inError"),
        backgroundColorHexa: ColorHexaEnum.red,
      },
      {
        key: StatusEnum.INPREPARATION,
        value: MARK_AS_TRANSLATABLE("order.enum.status.inPreparation"),
      },
      {
        key: StatusEnum.DOWNLOADING,
        value: MARK_AS_TRANSLATABLE("order.enum.status.downloading"),
      },
      {
        key: StatusEnum.SUBMITTED,
        value: MARK_AS_TRANSLATABLE("order.enum.status.submitted"),
      },
      {
        key: StatusEnum.INPROGRESS,
        value: MARK_AS_TRANSLATABLE("order.enum.status.inProgress"),
      },
      {
        key: StatusEnum.READY,
        value: MARK_AS_TRANSLATABLE("order.enum.status.ready"),
        backgroundColorHexa: ColorHexaEnum.green,
      },
      {
        key: StatusEnum.COMPLETED,
        value: MARK_AS_TRANSLATABLE("order.enum.status.completed"),
      },
      {
        key: StatusEnum.INDISSEMINATIONPREPARATION,
        value: MARK_AS_TRANSLATABLE("order.enum.status.inDisseminationPreparation"),
      },
    ];
  }

  export namespace Package {
    export type StatusEnum =
      "IN_ERROR"
      | "IN_PROGRESS"
      | "COMPLETED"
      | "IN_PREPARATION"
      | "READY"
      | "CHECKING"
      | "CHECKED"
      | "STORED"
      | "INDEXING"
      | "REINDEXING"
      | "DOWNLOADING"
      | "RELOADED"
      | "PRESERVATION_ERROR"
      | "CLEANING"
      | "CLEANED"
      | "DISPOSABLE"
      | "DISPOSAL_APPROVED_BY_ORGUNIT"
      | "DISPOSAL_APPROVED"
      | "DISPOSED"
      | "REPLICATING_TOMBSTONE"
      | "REPLICATING_PACKAGE"
      | "UPDATING_RETENTION";
    export const StatusEnum = {
      IN_ERROR: "IN_ERROR" as StatusEnum,
      IN_PROGRESS: "IN_PROGRESS" as StatusEnum,
      COMPLETED: "COMPLETED" as StatusEnum,
      IN_PREPARATION: "IN_PREPARATION" as StatusEnum,
      READY: "READY" as StatusEnum,
      CHECKING: "CHECKING" as StatusEnum,
      CHECKED: "CHECKED" as StatusEnum,
      STORED: "STORED" as StatusEnum,
      INDEXING: "INDEXING" as StatusEnum,
      REINDEXING: "REINDEXING" as StatusEnum,
      DOWNLOADING: "DOWNLOADING" as StatusEnum,
      RELOADED: "RELOADED" as StatusEnum,
      PRESERVATION_ERROR: "PRESERVATION_ERROR" as StatusEnum,
      CLEANING: "CLEANING" as StatusEnum,
      CLEANED: "CLEANED" as StatusEnum,
      DISPOSABLE: "DISPOSABLE" as StatusEnum,
      DISPOSAL_APPROVED_BY_ORGUNIT: "DISPOSAL_APPROVED_BY_ORGUNIT" as StatusEnum,
      DISPOSAL_APPROVED: "DISPOSAL_APPROVED" as StatusEnum,
      DISPOSED: "DISPOSED" as StatusEnum,
      REPLICATING_TOMBSTONE: "REPLICATING_TOMBSTONE" as StatusEnum,
      REPLICATING_PACKAGE: "REPLICATING_PACKAGE" as StatusEnum,
      UPDATING_RETENTION: "UPDATING_RETENTION" as StatusEnum,
    };
    export const StatusEnumTranslate: StatusModel[] = [
      {
        key: StatusEnum.IN_ERROR,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.inError"),
        backgroundColorHexa: ColorHexaEnum.red,
      },
      {
        key: StatusEnum.IN_PROGRESS,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.inProgress"),
      },
      {
        key: StatusEnum.COMPLETED,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.completed"),
        backgroundColorHexa: ColorHexaEnum.green,
      },
      {
        key: StatusEnum.IN_PREPARATION,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.inPreparation"),
      },
      {
        key: StatusEnum.READY,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.ready"),
      },
      {
        key: StatusEnum.CHECKING,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.checking"),
      },
      {
        key: StatusEnum.CHECKED,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.checked"),
      },
      {
        key: StatusEnum.STORED,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.stored"),
      },
      {
        key: StatusEnum.INDEXING,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.indexing"),
      },
      {
        key: StatusEnum.REINDEXING,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.reindexing"),
      },
      {
        key: StatusEnum.DOWNLOADING,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.downloading"),
      },
      {
        key: StatusEnum.RELOADED,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.reloaded"),
      },
      {
        key: StatusEnum.PRESERVATION_ERROR,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.preservationError"),
      },
      {
        key: StatusEnum.CLEANING,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.cleaning"),
      },
      {
        key: StatusEnum.CLEANED,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.cleaned"),
        backgroundColorHexa: ColorHexaEnum.green,
      },
      {
        key: StatusEnum.DISPOSABLE,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.disposable"),
      },
      {
        key: StatusEnum.DISPOSAL_APPROVED_BY_ORGUNIT,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.disposalApprovedByOrgunit"),
      },
      {
        key: StatusEnum.DISPOSAL_APPROVED,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.disposalApproved"),
      },
      {
        key: StatusEnum.DISPOSED,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.disposed"),
        backgroundColorHexa: ColorHexaEnum.green,
      },
      {
        key: StatusEnum.REPLICATING_TOMBSTONE,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.replicatingTombstone"),
      },
      {
        key: StatusEnum.REPLICATING_PACKAGE,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.replicatingPackage"),
      },
      {
        key: StatusEnum.UPDATING_RETENTION,
        value: MARK_AS_TRANSLATABLE("enum.packageStatus.updatingRetention"),
      },
    ];

    export function statusIsCompleted(status: StatusEnum): boolean {
      return (status === StatusEnum.COMPLETED || status === StatusEnum.DISPOSED);
    }

    export function statusIsDisposable(status: StatusEnum): boolean {
      return (status === StatusEnum.DISPOSABLE);
    }
  }

  export namespace PreservationJob {
    export type RecurrenceEnum = PreservationJobPartial.JobRecurrenceEnum;
    export const RecurrenceEnum = PreservationJobPartial.JobRecurrenceEnum;
    export const RecurrenceEnumTranslate: KeyValue[] = [
      {
        key: RecurrenceEnum.DAILY,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobRecurrenceEnum.daily"),
      },
      {
        key: RecurrenceEnum.WEEKLY,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobRecurrenceEnum.weekly"),
      },
      {
        key: RecurrenceEnum.MONTHLY,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobRecurrenceEnum.monthly"),
      },
      {
        key: RecurrenceEnum.YEARLY,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobRecurrenceEnum.yearly"),
      },
      {
        key: RecurrenceEnum.ONCE,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobRecurrenceEnum.once"),
      },
    ];

    export type TypeEnum = PreservationJobPartial.JobTypeEnum;
    export const TypeEnum = PreservationJobPartial.JobTypeEnum;
    export const TypeEnumTranslate: KeyValue[] = [
      {
        key: TypeEnum.CLEANSUBMISSION,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.cleanSubmission"),
      },
      {
        key: TypeEnum.FIXITY,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.fixity"),
      },
      {
        key: TypeEnum.MIGRATION,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.migration"),
      },
      {
        key: TypeEnum.PURGESUBMISSIONTEMPFILES,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.purgeSubmissionTempFiles"),
      },
      {
        key: TypeEnum.REBUILDREGISTRY,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.rebuildRegistry"),
      },
      {
        key: TypeEnum.REINDEX,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.reindex"),
      },
      {
        key: TypeEnum.RELOAD,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.reload"),
      },
      {
        key: TypeEnum.REPLICATION,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.replication"),
      },
      {
        key: TypeEnum.REPLICATIONCHECK,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.replicationCheck"),
      },
      {
        key: TypeEnum.ARCHIVECHECK,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.archiveCheck"),
      },
      {
        key: TypeEnum.DISPOSAL,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.disposal"),
      },
      {
        key: TypeEnum.ARCHIVEPRELOADSMALL,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.archivePreloadSmall"),
      },
      {
        key: TypeEnum.ARCHIVEPRELOADBIG,
        value: MARK_AS_TRANSLATABLE("preservation.job.jobTypeEnum.archivePreloadBig"),
      },
    ];

    export type ExecutionReportStatusEnum =
      "PROCESSED"
      | "IGNORED"
      | "ERROR";
    export const JobExecutionReportStatusEnum = {
      PROCESSED: "PROCESSED" as ExecutionReportStatusEnum,
      IGNORED: "IGNORED" as ExecutionReportStatusEnum,
      ERROR: "ERROR" as ExecutionReportStatusEnum,
    };
    export const ExecutionReportStatusEnumTranslate: StatusModel[] = [
      {
        key: JobExecutionReportStatusEnum.PROCESSED,
        value: MARK_AS_TRANSLATABLE("preservation.jobExecution.report.detail.jobStatusEnum.processed"),
        backgroundColorHexa: ColorHexaEnum.green,
      },
      {
        key: JobExecutionReportStatusEnum.IGNORED,
        value: MARK_AS_TRANSLATABLE("preservation.jobExecution.report.detail.jobStatusEnum.ignored"),
      },
      {
        key: JobExecutionReportStatusEnum.ERROR,
        value: MARK_AS_TRANSLATABLE("preservation.jobExecution.report.detail.jobStatusEnum.error"),
        backgroundColorHexa: ColorHexaEnum.red,
      },
    ];

    export type ExecutionStatusEnum =
      "IN_PROGRESS"
      | "COMPLETED"
      | "READY"
      | "PAUSED"
      | "IN_ERROR";
    export const ExecutionStatusEnum = {
      IN_PROGRESS: "IN_PROGRESS" as ExecutionStatusEnum,
      COMPLETED: "COMPLETED" as ExecutionStatusEnum,
      READY: "READY" as ExecutionStatusEnum,
      PAUSED: "PAUSED" as ExecutionStatusEnum,
      IN_ERROR: "IN_ERROR" as ExecutionStatusEnum,
    };
    export const ExecutionStatusEnumTranslate: StatusModel[] = [
      {
        key: ExecutionStatusEnum.IN_PROGRESS,
        value: MARK_AS_TRANSLATABLE("preservation.jobExecution.jobStatusEnum.inProgress"),
      },
      {
        key: ExecutionStatusEnum.COMPLETED,
        value: MARK_AS_TRANSLATABLE("preservation.jobExecution.jobStatusEnum.completed"),
        backgroundColorHexa: ColorHexaEnum.green,
      },
      {
        key: ExecutionStatusEnum.READY,
        value: MARK_AS_TRANSLATABLE("preservation.jobExecution.jobStatusEnum.ready"),
      },
      {
        key: ExecutionStatusEnum.PAUSED,
        value: MARK_AS_TRANSLATABLE("preservation.jobExecution.jobStatusEnum.paused"),
      },
      {
        key: ExecutionStatusEnum.IN_ERROR,
        value: MARK_AS_TRANSLATABLE("preservation.jobExecution.jobStatusEnum.inError"),
        backgroundColorHexa: ColorHexaEnum.red,
      },
    ];
  }

  export namespace Result {
    export type ActionStatusEnum = "EXECUTED" | "NOT_EXECUTED" | "NON_APPLICABLE";
    export const ActionStatusEnum = {
      EXECUTED: "EXECUTED" as ActionStatusEnum,
      NOT_EXECUTED: "NOT_EXECUTED" as ActionStatusEnum,
      NON_APPLICABLE: "NON_APPLICABLE" as ActionStatusEnum,
    };
  }

  export namespace RetentionPolicy {
    export type RetentionPolicyEnum =
      "days"
      | "years"
      | "centuries"
      | "forever";
    export const RetentionPolicyEnum = {
      days: "days" as RetentionPolicyEnum,
      years: "years" as RetentionPolicyEnum,
      centuries: "centuries" as RetentionPolicyEnum,
      forever: "forever" as RetentionPolicyEnum,
    };
    export const RetentionPolicyEnumTranslate: KeyValue[] = [
      {
        key: RetentionPolicyEnum.days,
        value: MARK_AS_TRANSLATABLE("admin.preservationPolicy.retention.days"),
      },
      {
        key: RetentionPolicyEnum.years,
        value: MARK_AS_TRANSLATABLE("admin.preservationPolicy.retention.years"),
      },
      {
        key: RetentionPolicyEnum.centuries,
        value: MARK_AS_TRANSLATABLE("admin.preservationPolicy.retention.centuries"),
      },
      {
        key: RetentionPolicyEnum.forever,
        value: MARK_AS_TRANSLATABLE("admin.preservationPolicy.retention.forever"),
      },
    ];
  }

  export namespace Role {
    export type RoleEnum =
      "APPROVER"
      | "CREATOR"
      | "MANAGER"
      | "STEWARD"
      | "VISITOR";
    export const RoleEnum = {
      APPROVER: "APPROVER" as RoleEnum,
      CREATOR: "CREATOR" as RoleEnum,
      MANAGER: "MANAGER" as RoleEnum,
      STEWARD: "STEWARD" as RoleEnum,
      VISITOR: "VISITOR" as RoleEnum,
    };
  }

  export namespace UserApplicationRole {
    export type UserApplicationRoleEnum =
      "ROOT"
      | "ADMIN"
      | "USER"
      | "TRUSTED_CLIENT"
      | "GUEST";
    export const UserApplicationRoleEnum = {
      root: "ROOT" as UserApplicationRoleEnum,
      admin: "ADMIN" as UserApplicationRoleEnum,
      user: "USER" as UserApplicationRoleEnum,
      trusted_client: "TRUSTED_CLIENT" as UserApplicationRoleEnum,
      guest: "GUEST" as UserApplicationRoleEnum,
    };
    export const UserApplicationRoleEnumTranslate: KeyValue[] = [
      {
        key: UserApplicationRoleEnum.admin,
        value: MARK_AS_TRANSLATABLE("admin.user.roles.admin"),
      },
      {
        key: UserApplicationRoleEnum.root,
        value: MARK_AS_TRANSLATABLE("admin.user.roles.root"),
      },
      {
        key: UserApplicationRoleEnum.user,
        value: MARK_AS_TRANSLATABLE("admin.user.roles.user"),
      },
      {
        key: UserApplicationRoleEnum.trusted_client,
        value: MARK_AS_TRANSLATABLE("admin.user.roles.trustedClient"),
      },
    ];
  }

  // Need to be at the end for allow aggregation of status
  export namespace History {
    export const StatusEnumTranslate: StatusModel[] = [
      ...Enums.Package.StatusEnumTranslate,
      ...Enums.Order.StatusEnumTranslate,
      ...Enums.DataFile.StatusEnumTranslate,
      ...Enums.Deposit.StatusEnumTranslate,
      {
        key: "CREATED",
        value: MARK_AS_TRANSLATABLE("enum.historyStatus.created"),
      },
    ];
  }

}
