import {
  ChangeDetectionStrategy,
  Component,
  OnInit,
} from "@angular/core";
import {FullPageModeRoutable} from "@app/components/routables/full-page-mode/full-page-mode.routable";
import {AppState} from "@app/stores/app.state";
import {Store} from "@ngxs/store";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OAuth2Service,
} from "solidify-frontend";

@Component({
  selector: "dlcm-maintenance-mode-routable",
  templateUrl: "./maintenance-mode.routable.html",
  styleUrls: ["./maintenance-mode.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class MaintenanceModeRoutable extends FullPageModeRoutable implements OnInit {
  isLoggedIsObs: Observable<boolean> = MemoizedUtil.select(this._store, AppState, state => state.isLoggedIn);

  constructor(private readonly _store: Store,
              private readonly _oauthService: OAuth2Service) {
    super();
  }

  login(): void {
    this._oauthService.initAuthorizationCodeFlow();
  }
}
