import {
  Directive,
  OnInit,
} from "@angular/core";
import {environment} from "@environments/environment";
import {SharedAbstractRoutable} from "@shared/components/routables/shared-abstract/shared-abstract.routable";

@Directive()
export abstract class FullPageModeRoutable extends SharedAbstractRoutable implements OnInit {
  logo: string;

  constructor() {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.logo = `assets/themes/${environment.theme}/toolbar-header-image.svg`;
  }

  refresh(): void {
    window.open(".", "_self");
  }
}
