import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {TokenDialog} from "@app/components/dialogs/token/token.dialog";
import {UserDialog} from "@app/components/dialogs/user/user.dialog";
import {MenuToolbar} from "@app/components/presentationals/main-toolbar/abstract-main-toolbar/abstract-main-toolbar.presentational";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {environment} from "@environments/environment";
import {User} from "@models";
import {ThemeEnum} from "@shared/enums/theme.enum";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {ObservableUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-user-menu",
  templateUrl: "./user-menu.presentational.html",
  styleUrls: ["./user-menu.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class UserMenuPresentational extends SharedAbstractPresentational {
  isDemoMode: boolean = environment.isDemoMode;
  isProduction: boolean = environment.production;

  @Input()
  user: User;

  @Input()
  photoUser: string;

  @Input()
  mode: "horizontal" | "vertical" = "vertical";

  private get _theme(): ThemeEnum | undefined {
    return this._themeChangeBS.getValue();
  }

  private set _theme(value: ThemeEnum | undefined) {
    this._themeChangeBS.next(value);
  }

  get theme(): ThemeEnum | undefined {
    return this._theme;
  }

  @Input()
  set theme(theme: ThemeEnum | undefined) {
    this._theme = theme;
  }

  @Input()
  listMenuAdmin: MenuToolbar[];

  private readonly DEFAULT_INITIAL: string = "U";

  initial: string = this.DEFAULT_INITIAL;

  // Logout
  private readonly _logoutBS: BehaviorSubject<void | undefined> = new BehaviorSubject<void | undefined>(undefined);
  @Output("logoutChange")
  readonly logoutObs: Observable<void | undefined> = ObservableUtil.asObservable(this._logoutBS);

  private readonly _userGuideOpenBS: BehaviorSubject<void | undefined> = new BehaviorSubject<void | undefined>(undefined);
  @Output("userGuideOpen")
  readonly userGuideOpenObs: Observable<void | undefined> = ObservableUtil.asObservable(this._userGuideOpenBS);

  private readonly _themeChangeBS: BehaviorSubject<ThemeEnum | undefined> = new BehaviorSubject<ThemeEnum | undefined>(undefined);
  @Output("themeChange")
  readonly themeChangeObs: Observable<ThemeEnum | undefined> = ObservableUtil.asObservable(this._themeChangeBS);

  constructor(private dialog: MatDialog) {
    super();
  }

  logout(): void {
    this._logoutBS.next();
  }

  displayToken(): void {
    this.dialog.open(TokenDialog);
  }

  profileInfo(): void {
    this.dialog.open(UserDialog, {
      data: this.user,
      width: "90%",
    });
  }

  openUserGuide(): void {
    this._userGuideOpenBS.next();
  }

  toggleDarkMode(): void {

  }
}
