import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {ThemeEnum} from "@app/shared/enums/theme.enum";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  isNullOrUndefined,
  ObservableUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-theme-selector",
  templateUrl: "./theme-selector.presentational.html",
  styleUrls: ["./theme-selector.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class ThemeSelectorPresentational extends SharedAbstractPresentational {
  // Theme
  private readonly _themeBS: BehaviorSubject<ThemeEnum | undefined> = new BehaviorSubject<ThemeEnum | undefined>(undefined);
  @Output("themeChange")
  readonly themeObs: Observable<ThemeEnum | undefined> = ObservableUtil.asObservable(this._themeBS);

  private get _theme(): ThemeEnum | undefined {
    return this._themeBS.getValue();
  }

  private set _theme(value: ThemeEnum | undefined) {
    if (this._themeBS.value !== value) {
      this._themeBS.next(value);
    }
  }

  get theme(): ThemeEnum | undefined {
    return this._theme;
  }

  @Input()
  set theme(theme: ThemeEnum | undefined) {
    this._theme = theme;
  }

  getPathToImage(theme: ThemeEnum): string {
    if (isNullOrUndefined(theme)) {
      return undefined;
    }
    return "assets/themes/" + theme + "/logo.svg";
  }
}
