import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
  ViewChild,
} from "@angular/core";
import {MatMenu} from "@angular/material/menu";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {ThemeEnum} from "@app/shared/enums/theme.enum";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  isNullOrUndefined,
  ObservableUtil,
  StringUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-theme-selector-menu",
  templateUrl: "./theme-selector-menu.presentational.html",
  styleUrls: ["./theme-selector-menu.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  exportAs: "menuTheme",
})
export class ThemeSelectorMenuPresentational extends SharedAbstractPresentational {
  @ViewChild(MatMenu, {static: true}) menu: MatMenu;

  listThemes: ThemeEnum[] = [ThemeEnum.dlcm, ThemeEnum.yareta, ThemeEnum.olos, ThemeEnum.vertical];

  // Theme
  private readonly _themeBS: BehaviorSubject<ThemeEnum | undefined> = new BehaviorSubject<ThemeEnum | undefined>(undefined);
  @Output("themeChange")
  readonly themeObs: Observable<ThemeEnum | undefined> = ObservableUtil.asObservable(this._themeBS);

  private get _theme(): ThemeEnum | undefined {
    return this._themeBS.getValue();
  }

  private set _theme(value: ThemeEnum | undefined) {
    if (this._themeBS.value !== value) {
      this._themeBS.next(value);
    }
  }

  get theme(): ThemeEnum | undefined {
    return this._theme;
  }

  @Input()
  set theme(theme: ThemeEnum | undefined) {
    this._theme = theme;
  }

  get stringUtil(): typeof StringUtil {
    return StringUtil;
  }

  getPathToImage(theme: ThemeEnum): string {
    if (isNullOrUndefined(theme)) {
      return undefined;
    }
    return "assets/themes/" + theme + "/logo.svg";
  }

  selectTheme(theme: ThemeEnum): void {
    this._themeBS.next(theme);
  }
}
