import {
  ChangeDetectionStrategy,
  Component,
  HostBinding,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {environment} from "@environments/environment";

@Component({
  selector: "dlcm-ribbon",
  templateUrl: "./ribbon.presentational.html",
  styleUrls: ["./ribbon.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class RibbonPresentational extends SharedAbstractPresentational {
  @HostBinding("class.is-visible")
  isVisible: boolean = environment.ribbonEnabled;

  text: string = environment.ribbonText;

  @HostBinding("style.background-color")
  color: string = environment.ribbonColor;
}
