import {
  ChangeDetectionStrategy,
  Component,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {Navigate} from "@ngxs/router-plugin";
import {Store} from "@ngxs/store";
import {RoutesEnum} from "@shared/enums/routes.enum";

@Component({
  selector: "dlcm-page-not-found",
  templateUrl: "./page-not-found.presentational.html",
  styleUrls: ["./page-not-found.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PageNotFoundPresentational extends SharedAbstractPresentational {
  constructor(private readonly _store: Store) {
    super();
  }

  backToHome(): void {
    this._store.dispatch(new Navigate([RoutesEnum.homePage]));
  }
}
