import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
} from "@angular/core";
import {Enums} from "@enums";
import {User} from "@models";
import {SharedAbstractPresentational} from "@shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {ThemeEnum} from "@shared/enums/theme.enum";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {ObservableUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-main-toolbar",
  templateUrl: "./main-toolbar.presentational.html",
  styleUrls: ["./main-toolbar.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class MainToolbarPresentational extends SharedAbstractPresentational {
  @Input()
  logged: boolean = false;

  @Input()
  currentPath: string;

  @Input()
  currentLanguage: Enums.Language.LanguageEnum;

  @Input()
  userRoles: Enums.UserApplicationRole.UserApplicationRoleEnum[];

  @Input()
  user: User;

  @Input()
  photoUser: string;

  @Input()
  numberArchiveInCart: number;

  @Input()
  numberMyOrderReadyNew: number;

  @Input()
  numberPendingRequestNotificationInbox: number;

  @Input()
  theme: ThemeEnum;

  @Input()
  logo: string;

  @Input()
  displayCart: boolean;

  @Input()
  isHomePage: boolean;

  private readonly _themeBS: BehaviorSubject<ThemeEnum | undefined> = new BehaviorSubject<ThemeEnum | undefined>(undefined);
  @Output("themeChange")
  readonly themeObs: Observable<ThemeEnum | undefined> = ObservableUtil.asObservable(this._themeBS);

  // Navigate
  private readonly _navigateBS: BehaviorSubject<string | undefined> = new BehaviorSubject<string | undefined>(undefined);
  @Output("navigateChange")
  readonly navigateObs: Observable<string | undefined> = ObservableUtil.asObservable(this._navigateBS);

  // Language
  private readonly _languageBS: BehaviorSubject<Enums.Language.LanguageEnum | undefined> = new BehaviorSubject<Enums.Language.LanguageEnum | undefined>(undefined);
  @Output("languageChange")
  readonly languageObs: Observable<Enums.Language.LanguageEnum | undefined> = ObservableUtil.asObservable(this._languageBS);

  // Logout
  private readonly _logoutBS: BehaviorSubject<void | undefined> = new BehaviorSubject<void | undefined>(undefined);
  @Output("logoutChange")
  readonly logoutObs: Observable<void | undefined> = ObservableUtil.asObservable(this._logoutBS);

  // UserGuide
  private readonly _userGuideOpenBS: BehaviorSubject<void | undefined> = new BehaviorSubject<void | undefined>(undefined);
  @Output("userGuideOpen")
  readonly userGuideOpenObs: Observable<void | undefined> = ObservableUtil.asObservable(this._userGuideOpenBS);

  //Search
  private readonly _searchBS: BehaviorSubject<string | undefined> = new BehaviorSubject<string | undefined>(undefined);
  @Output("searchChange")
  readonly searchObs: Observable<string | undefined> = ObservableUtil.asObservable(this._searchBS);

  changeTheme(theme: ThemeEnum): void {
    if (this._themeBS.value !== theme) {
      this._themeBS.next(theme);
    }
  }

  changeLanguage(language: Enums.Language.LanguageEnum): void {
    if (this._languageBS.value !== language) {
      this._languageBS.next(language);
    }
  }

  changeNavigate(navigate: string): void {
    this._navigateBS.next(navigate);
  }

  logout(): void {
    this._logoutBS.next();
  }

  openUserGuide(): void {
    this._userGuideOpenBS.next();
  }

  search(value: string): void {
    this._searchBS.next(value);
  }
}
