import {
  animate,
  state,
  style,
  transition,
  trigger,
} from "@angular/animations";
import {
  ChangeDetectionStrategy,
  Component,
} from "@angular/core";
import {AbstractMainToolbarPresentational} from "@app/components/presentationals/main-toolbar/abstract-main-toolbar/abstract-main-toolbar.presentational";
import {AppUtil} from "@app/shared/utils/app.util";
import {
  OAuth2Service,
  Override,
} from "solidify-frontend";

@Component({
  selector: "dlcm-main-toolbar-mobile",
  templateUrl: "./main-toolbar-mobile.presentational.html",
  styleUrls: ["./main-toolbar-mobile.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [
    trigger("menuAnimation", [
      state("void", style({transform: "translateY(-100%)"})),
      transition(":enter", animate("600ms ease")),
      transition(":leave", animate("300ms ease")),
    ]),
  ],
})
export class MainToolbarMobilePresentational extends AbstractMainToolbarPresentational {
  get appUtil(): typeof AppUtil {
    return AppUtil;
  }

  constructor(private oauth: OAuth2Service) {
    super(oauth);
  }

  @Override()
  navigate(path: string): void {
    super.navigate(path);
    this.toggleMenu();
  }

  @Override()
  logout(): void {
    super.logout();
    this.toggleMenu();
  }

  @Override()
  login(): void {
    super.login();
    this.toggleMenu();
  }
}
