import {HttpClientTestingModule} from "@angular/common/http/testing";
import {NO_ERRORS_SCHEMA} from "@angular/core";
import {
  async,
  ComponentFixture,
  TestBed,
} from "@angular/core/testing";
import {MatSnackBar} from "@angular/material/snack-bar";
import {LanguageSelectorPresentational} from "@app/components/presentationals/language-selector/language-selector.presentational";
import {FontAwesomeModule} from "@fortawesome/angular-fontawesome";
import {
  ENVIRONMENT,
  SNACK_BAR,
} from "solidify-frontend";
import {environment} from "../../../../../environments/environment";
import {MockTranslatePipe} from "../../../../../test-helpers/mock-translate.pipe";
import {MainToolbarMobilePresentational} from "./main-toolbar-mobile.presentational";

describe("MainToolbarMobilePresentational", () => {
  let component: MainToolbarMobilePresentational;
  let fixture: ComponentFixture<MainToolbarMobilePresentational>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [MainToolbarMobilePresentational, LanguageSelectorPresentational, MockTranslatePipe],
      imports: [HttpClientTestingModule, FontAwesomeModule],
      schemas: [NO_ERRORS_SCHEMA],
      providers: [
        {
          provide: ENVIRONMENT,
          useValue: environment,
        },
        {
          provide: SNACK_BAR,
          useClass: MatSnackBar,
        },
      ],
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(MainToolbarMobilePresentational);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  xit("should create", () => {
    expect(component).toBeTruthy();
  });
});
