import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
} from "@angular/core";
import {AbstractMainToolbarPresentational} from "@app/components/presentationals/main-toolbar/abstract-main-toolbar/abstract-main-toolbar.presentational";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {BreakpointService} from "@shared/services/breakpoint.service";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  OAuth2Service,
  ObservableUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-main-toolbar-desktop-horizontal",
  templateUrl: "./main-toolbar-desktop-horizontal.presentational.html",
  styleUrls: ["./main-toolbar-desktop-horizontal.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class MainToolbarDesktopHorizontalPresentational extends AbstractMainToolbarPresentational {
  @Input()
  logo: string;

  @Input()
  displayCart: boolean;

  @Input()
  isHomePage: boolean;

  private readonly _userGuideOpenBS: BehaviorSubject<void | undefined> = new BehaviorSubject<void | undefined>(undefined);
  @Output("userGuideOpen")
  readonly userGuideOpenObs: Observable<void | undefined> = ObservableUtil.asObservable(this._userGuideOpenBS);

  private readonly _searchBS: BehaviorSubject<string | undefined> = new BehaviorSubject<string | undefined>(undefined);
  @Output("searchChange")
  readonly searchObs: Observable<string | undefined> = ObservableUtil.asObservable(this._searchBS);

  constructor(private oauth: OAuth2Service,
              public breakpointService: BreakpointService) {
    super(oauth);
  }

  navigateToHome(): void {
    this._navigateBS.next(RoutesEnum.homePage);
  }

  openUserGuide(): void {
    this._userGuideOpenBS.next();
  }

  search(value: string): void {
    this._searchBS.next(value);
  }
}
