import {HttpClientTestingModule} from "@angular/common/http/testing";
import {NO_ERRORS_SCHEMA} from "@angular/core";
import {
  async,
  ComponentFixture,
  TestBed,
} from "@angular/core/testing";
import {MatSnackBar} from "@angular/material/snack-bar";
import {LanguageSelectorPresentational} from "@app/components/presentationals/language-selector/language-selector.presentational";
import {
  ENVIRONMENT,
  SNACK_BAR,
} from "solidify-frontend";
import {environment} from "../../../../../environments/environment";
import {MockTranslatePipe} from "../../../../../test-helpers/mock-translate.pipe";

import {MainToolbarDesktopHorizontalPresentational} from "./main-toolbar-desktop-horizontal.presentational";

describe("MainToolbarDesktopHorizontalPresentational", () => {
  let component: MainToolbarDesktopHorizontalPresentational;
  let fixture: ComponentFixture<MainToolbarDesktopHorizontalPresentational>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [HttpClientTestingModule],
      declarations: [MainToolbarDesktopHorizontalPresentational, LanguageSelectorPresentational, MockTranslatePipe],
      schemas: [NO_ERRORS_SCHEMA],
      providers: [
        {
          provide: ENVIRONMENT,
          useValue: environment,
        },
        {
          provide: SNACK_BAR,
          useClass: MatSnackBar,
        },
      ],
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(MainToolbarDesktopHorizontalPresentational);
    component = fixture.componentInstance;
  });

  xit("should create", () => {
    expect(() => fixture.detectChanges()).not.toThrow();
  });

});
