import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
  ViewEncapsulation,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {Enums} from "@enums";
import {environment} from "@environments/environment";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  EnumUtil,
  isNullOrUndefined,
  ObservableUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-language-selector",
  templateUrl: "./language-selector.presentational.html",
  styleUrls: ["./language-selector.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  encapsulation: ViewEncapsulation.None,
})
export class LanguageSelectorPresentational extends SharedAbstractPresentational {
  private _languageList: Enums.Language.LanguageEnum[] = environment.appLanguages;

  private readonly _languageBS: BehaviorSubject<Enums.Language.LanguageEnum | undefined> = new BehaviorSubject<Enums.Language.LanguageEnum | undefined>(undefined);

  @Input()
  currentLanguage: Enums.Language.LanguageEnum;

  @Output("languageChange")
  readonly languageObs: Observable<Enums.Language.LanguageEnum | undefined> = ObservableUtil.asObservable(this._languageBS);

  get language(): Enums.Language.LanguageEnum | undefined {
    return this._languageBS.getValue();
  }

  @Input()
  set language(value: Enums.Language.LanguageEnum | undefined) {
    if (this._languageBS.value !== value) {
      this._languageBS.next(value);
    }
  }

  get languageEnumTranslate(): typeof Enums.Language.LanguageEnumTranslate {
    return Enums.Language.LanguageEnumTranslate;
  }

  get enumUtil(): typeof EnumUtil {
    return EnumUtil;
  }

  useLanguage(language: Enums.Language.LanguageEnum): void {
    this._languageBS.next(language);
  }

  getPathToImage(language: Enums.Language.LanguageEnum): string | undefined {
    if (isNullOrUndefined(language)) {
      return undefined;
    }
    return "assets/language-icons/" + language + ".svg";
  }

  get languageList(): Enums.Language.LanguageEnum[] {
    return this._languageList.filter(l => this.language !== l && this.currentLanguage !== l);
  }
}
