import {
  ChangeDetectionStrategy,
  Component,
  ViewChild,
} from "@angular/core";
import {MatMenu} from "@angular/material/menu";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {Store} from "@ngxs/store";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {AppTourService} from "@shared/services/app-tour.service";
import {INgxmStepOption} from "ngx-tour-md-menu/lib/step-option.interface";
import {MARK_AS_TRANSLATABLE} from "solidify-frontend";

@Component({
  selector: "dlcm-guided-tour-menu",
  templateUrl: "./guided-tour-menu.presentational.html",
  styleUrls: ["./guided-tour-menu.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  exportAs: "menuGuidedTour",
})
export class GuidedTourMenuPresentational extends SharedAbstractPresentational {
  @ViewChild(MatMenu, {static: true}) menu: MatMenu;

  listMenu: Menu[] = [
    {
      titleToTranslate: MARK_AS_TRANSLATABLE("tour.name.main"),
      steps: this.appTourService.mainTourSteps,
    },
    {
      titleToTranslate: LabelTranslateEnum.deposit,
      steps: this.appTourService.depositListTourSteps,
      navigationEnd: RoutesEnum.deposit,
    },
    {
      titleToTranslate: MARK_AS_TRANSLATABLE("tour.name.depositMetadata"),
      steps: this.appTourService.depositMetadataTourSteps,
      navigationEnd: RoutesEnum.deposit,
    },
    {
      titleToTranslate: MARK_AS_TRANSLATABLE("tour.name.depositData"),
      steps: this.appTourService.depositDataTourSteps,
      navigationEnd: RoutesEnum.deposit,
    },
    {
      titleToTranslate: LabelTranslateEnum.preservationSpace,
      steps: this.appTourService.preservationSpaceTourSteps,
    },
    {
      titleToTranslate: LabelTranslateEnum.organizationalUnit,
      steps: this.appTourService.preservationSpaceOrgUnitTourSteps,
      navigationEnd: RoutesEnum.preservationSpaceOrganizationalUnit,
    },
    {
      titleToTranslate: LabelTranslateEnum.search,
      steps: this.appTourService.homeSearchTourSteps,
    },
  ];

  constructor(private readonly appTourService: AppTourService,
              private readonly _store: Store) {
    super();
  }

  runTour(menu: Menu): void {
    this.appTourService.runTour(menu.steps, menu.extraOptions, menu.navigationEnd);
  }
}

interface Menu {
  titleToTranslate: string;
  steps: INgxmStepOption[];
  extraOptions?: INgxmStepOption | undefined;
  navigationEnd?: string;
}
