import {
  ChangeDetectionStrategy,
  Component,
  HostBinding,
  Input,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {environment} from "@environments/environment";
import {GoogleAnalyticsService} from "@shared/services/google-analytics.service";

declare let gtag: Function;

@Component({
  selector: "dlcm-cookie-consent",
  templateUrl: "./cookie-consent.presentational.html",
  styleUrls: ["./cookie-consent.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CookieConsentPresentational extends SharedAbstractPresentational {
  @HostBinding("class.is-visible")
  @Input()
  isVisible: boolean;

  learnMoreLink: string = environment.googleAnalyticsLearnMorePage;

  constructor(private readonly _googleAnalyticsService: GoogleAnalyticsService) {
    super();
  }

  decline(): void {
    this._googleAnalyticsService.disableCookie();
  }

  accept(): void {
    this._googleAnalyticsService.enableCookie();
  }
}
