import {
  ChangeDetectionStrategy,
  Component,
  Inject,
  OnInit,
  ViewChild,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {AppPersonAction} from "@app/stores/person/app-person.action";
import {AppPersonState} from "@app/stores/person/app-person.state";
import {AppUserAction} from "@app/stores/user/app-user.action";
import {AppUserState} from "@app/stores/user/app-user.state";
import {
  Person,
  User,
} from "@models";
import {Store} from "@ngxs/store";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {SharedPersonFormPresentational} from "@shared/components/presentationals/shared-person-form/shared-person-form.presentational";
import {ResourceLogoNameSpace} from "@shared/stores/resource-logo/resource-logo-namespace.model";
import {Observable} from "rxjs";
import {
  isNullOrUndefined,
  MemoizedUtil,
  ModelFormControlEvent,
} from "solidify-frontend";

@Component({
  selector: "dlcm-user-dialog",
  templateUrl: "./user.dialog.html",
  styleUrls: ["./user.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class UserDialog extends SharedAbstractContainer implements OnInit {
  currentPersonObs: Observable<Person> = MemoizedUtil.current(this._store, AppPersonState);
  isLoadingPersonObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, AppPersonState);

  userAvatarActionNameSpace: ResourceLogoNameSpace = AppUserAction;
  userState: typeof AppUserState = AppUserState;

  validateEnable: boolean = false;

  @ViewChild("formPresentational")
  readonly formPresentational: SharedPersonFormPresentational;

  constructor(protected readonly _store: Store,
              protected readonly _dialogRef: MatDialogRef<UserDialog>,
              @Inject(MAT_DIALOG_DATA) public user: User) {
    super();
  }

  ngOnInit(): void {
    // Not necessary to refresh current user and cause ExpressionChangedAfterItHasBeenCheckedError when open profile info in deposit-edit.routable (cf DLCM-795)
    // this.store.dispatch(new AppPersonAction.GetById(this.user.person.resId));
  }

  savePersonInfo($event: ModelFormControlEvent<Person>): void {
    this._store.dispatch(new AppPersonAction.Update($event));
    // this.dialogRef.close();
  }

  getUser(): User {
    if (isNullOrUndefined(this.formPresentational)) {
      return this.user;
    }
    return this.formPresentational.form.value as User;
  }

  getPersonResId(): string {
    return this.user.person.resId;
  }

  activateButton($event: Event): void {
    this.validateEnable = true;
  }
}
