import {
  ChangeDetectionStrategy,
  Component,
  OnInit,
} from "@angular/core";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {JwtTokenHelper} from "@shared/helpers/jwt-token.helper";
import {Token} from "@shared/models/token.model";
import {
  ClipboardUtil,
  DateUtil,
  MARK_AS_TRANSLATABLE,
  NotificationService,
  OAuth2Service,
} from "solidify-frontend";

@Component({
  selector: "dlcm-token-dialog",
  templateUrl: "./token.dialog.html",
  styleUrls: ["./token.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class TokenDialog extends SharedAbstractContainer implements OnInit {
  tokenDecoded: Token;

  expiration: string = "";

  get token(): string {
    return this.oauth2Service.getAccessToken();
  }

  constructor(public oauth2Service: OAuth2Service,
              public notificationService: NotificationService) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.tokenDecoded = JwtTokenHelper.decodeToken(this.token);
    this.expiration = DateUtil.convertDateToDateTimeString(new Date(this.tokenDecoded.exp * 1000));
  }

  copy(): void {
    if (ClipboardUtil.copyStringToClipboard(this.token)) {
      this.notificationService.showInformation(MARK_AS_TRANSLATABLE("app.notification.tokenCopiedToClipboardSuccess"));
    } else {
      this.notificationService.showWarning(MARK_AS_TRANSLATABLE("app.notification.tokenCopiedToClipboardFail"));
    }
  }
}
