import {
  ChangeDetectionStrategy,
  Component,
} from "@angular/core";
import {MatDialogRef} from "@angular/material/dialog";
import {environment} from "@environments/environment";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {StringUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-first-login",
  templateUrl: "./first-login.dialog.html",
  styleUrls: ["./first-login.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class FirstLoginDialog extends SharedAbstractContainer {
  constructor(protected readonly _dialogRef: MatDialogRef<FirstLoginDialog>) {
    super();
  }


  get currentThemeName(): string {
    return StringUtil.convertToPascalCase(environment.theme);
  }

  startTour(): void {
    this._dialogRef.close(true);
  }
}
