import {
  ChangeDetectionStrategy,
  Component,
  Input,
  Output,
} from "@angular/core";
import {AppAction} from "@app/stores/app.action";
import {AppTocState} from "@app/stores/toc/app-toc.state";
import {environment} from "@environments/environment";
import {Store} from "@ngxs/store";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {AppUtil} from "@shared/utils/app.util";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  isNotNullNorUndefined,
  MemoizedUtil,
  ObservableUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-footer-container",
  templateUrl: "./footer.container.html",
  styleUrls: ["./footer.container.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class FooterContainer extends SharedAbstractContainer {
  isLoadingDocObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, AppTocState);
  toolsGuideObs: Observable<string> = MemoizedUtil.select(this._store, AppTocState, state => state.toolsGuide);
  integrationGuideObs: Observable<string> = MemoizedUtil.select(this._store, AppTocState, state => state.integrationGuide);
  apisObs: Observable<string> = MemoizedUtil.select(this._store, AppTocState, state => state.apis);
  userDocumentationObs: Observable<string> = MemoizedUtil.select(this._store, AppTocState, state => state.userDocumentation);
  displayButtonPrivacy: boolean = isNotNullNorUndefined(environment.googleAnalyticsId);

  @Input()
  updateVersion: string | undefined;

  private readonly _updateBS: BehaviorSubject<void> = new BehaviorSubject<void>(undefined);
  @Output("updateChange")
  readonly updateObs: Observable<void> = ObservableUtil.asObservable(this._updateBS);

  constructor(private readonly _store: Store) {
    super();
  }

  get appUtil(): typeof AppUtil {
    return AppUtil;
  }

  update(): void {
    this._updateBS.next();
  }

  displaySidebarUserGuide(): void {
    this._store.dispatch(new AppAction.ChangeDisplaySidebarUserGuide(true));
  }

  openCookieConsent(): void {
    this._store.dispatch(new AppAction.DisplayCookieConsent(true));
  }
}
