import {HttpClientTestingModule} from "@angular/common/http/testing";
import {
  async,
  ComponentFixture,
  TestBed,
} from "@angular/core/testing";
import {MatSnackBar} from "@angular/material/snack-bar";
import {NoopAnimationsModule} from "@angular/platform-browser/animations";
import {AppState} from "@app/stores/app.state";
import {AppPersonState} from "@app/stores/person/app-person.state";
import {AppUserState} from "@app/stores/user/app-user.state";
import {environment} from "@environments/environment";
import {
  TranslatePipe,
  TranslateService,
} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {SharedModule} from "@shared/shared.module";
import {
  ENVIRONMENT,
  SNACK_BAR,
} from "solidify-frontend";
import {MockTranslatePipe} from "../../../../test-helpers/mock-translate.pipe";
import {MockTranslateService} from "../../../../test-helpers/mock-translate.service";

import {FooterContainer} from "./footer.container";

xdescribe("FooterPresentational", () => {
  let component: FooterContainer;
  let fixture: ComponentFixture<FooterContainer>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [FooterContainer],
      imports: [
        HttpClientTestingModule,
        NoopAnimationsModule,
        NgxsModule.forRoot([AppState, AppUserState, AppPersonState]),
        SharedModule,
      ],
      providers: [
        {
          provide: TranslateService,
          useClass: MockTranslateService,
        },
        {
          provide: TranslatePipe,
          useClass: MockTranslatePipe,
        },
        {
          provide: ENVIRONMENT,
          useValue: environment,
        },
        {
          provide: SNACK_BAR,
          useClass: MatSnackBar,
        },
      ],
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(FooterContainer);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it("should create", () => {
    expect(() => fixture.detectChanges()).not.toThrow();
  });
});
