import {
  HTTP_INTERCEPTORS,
  HttpClient,
  HttpClientModule,
} from "@angular/common/http";
import {
  APP_INITIALIZER,
  ErrorHandler,
  NgModule,
} from "@angular/core";
import {ReactiveFormsModule} from "@angular/forms";
import {
  MAT_MOMENT_DATE_ADAPTER_OPTIONS,
  MAT_MOMENT_DATE_FORMATS,
  MomentDateAdapter,
} from "@angular/material-moment-adapter";
import {
  DateAdapter,
  MAT_DATE_FORMATS,
  MAT_DATE_LOCALE,
} from "@angular/material/core";
import {MatPaginatorIntl} from "@angular/material/paginator";
import {MatSnackBar} from "@angular/material/snack-bar";
import {BrowserModule} from "@angular/platform-browser";
import {BrowserAnimationsModule} from "@angular/platform-browser/animations";
import {ServiceWorkerModule} from "@angular/service-worker";
import {AppRoutingModule} from "@app/app-routing.module";
import {FooterContainer} from "@app/components/container/footer/footer.container";
import {FirstLoginDialog} from "@app/components/dialogs/first-login/first-login.dialog";
import {TokenDialog} from "@app/components/dialogs/token/token.dialog";
import {UpdateVersionDialog} from "@app/components/dialogs/update-version/update-version.dialog";
import {UserDialog} from "@app/components/dialogs/user/user.dialog";
import {CookieConsentPresentational} from "@app/components/presentationals/cookie-consent/cookie-consent.presentational";
import {GuidedTourMenuPresentational} from "@app/components/presentationals/guided-tour-menu/guided-tour-menu.presentational";
import {BurgerMenuPresentational} from "@app/components/presentationals/main-toolbar/burger-menu/burger-menu.presentational";
import {MainToolbarDesktopVerticalPresentational} from "@app/components/presentationals/main-toolbar/main-toolbar-desktop-vertical/main-toolbar-desktop-vertical.presentational";
import {MainToolbarMobilePresentational} from "@app/components/presentationals/main-toolbar/main-toolbar-mobile/main-toolbar-mobile.presentational";
import {MainToolbarPresentational} from "@app/components/presentationals/main-toolbar/main-toolbar/main-toolbar.presentational";
import {RibbonPresentational} from "@app/components/presentationals/ribbon/ribbon.presentational";
import {ThemeSelectorMenuPresentational} from "@app/components/presentationals/theme-selector-menu/theme-selector-menu.presentational";
import {ThemeSelectorPresentational} from "@app/components/presentationals/theme-selector/theme-selector.presentational";
import {UserFormPresentational} from "@app/components/presentationals/user-form/user-form.presentational";
import {UserMenuPresentational} from "@app/components/presentationals/user-menu/user-menu.presentational";
import {IconAppRoutable} from "@app/components/routables/icon-app/icon-app.routable";
import {MaintenanceModeRoutable} from "@app/components/routables/maintenance-mode/maintenance-mode.routable";
import {ServerOfflineModeRoutable} from "@app/components/routables/server-offline-mode/server-offline-mode.routable";
import {InMemoryStorage} from "@app/in-memory.storage";
import {DlcmErrorsHandlerService} from "@app/shared/services/dlcm-errors-handler.service";
import {SharedModule} from "@app/shared/shared.module";
import {AppState} from "@app/stores/app.state";
import {AppArchiveAclState} from "@app/stores/archive-acl/app-archive-acl.state";
import {AppAuthorizedOrganizationalUnitState} from "@app/stores/authorized-organizational-unit/app-authorized-organizational-unit.state";
import {AppBannerState} from "@app/stores/banner/app-banner.state";
import {AppCarouselState} from "@app/stores/carousel/app-carousel.state";
import {AppCartState} from "@app/stores/cart/app-cart.state";
import {AppCartArchiveState} from "@app/stores/cart/archive/app-cart-archive.state";
import {AppCartDipState} from "@app/stores/cart/dip/app-cart-dip.state";
import {AppCartDipDataFileState} from "@app/stores/cart/dip/data-file/app-cart-dip-data-file.state";
import {AppCartOrderState} from "@app/stores/cart/order/app-cart-order.state";
import {AppNotificationInboxState} from "@app/stores/notification-inbox/app-notification-inbox.state";
import {AppOrganizationalUnitPersonRoleState} from "@app/stores/organizational-unit-person-role/app-organizational-unit-person-role.state";
import {AppPersonState} from "@app/stores/person/app-person.state";
import {AppSystemPropertyState} from "@app/stores/system-property/app-system-property.state";
import {AppTocState} from "@app/stores/toc/app-toc.state";
import {AppUserState} from "@app/stores/user/app-user.state";
import {versions} from "@environments/versions";
import {FormlyModule} from "@ngx-formly/core";
import {FormlyMaterialModule} from "@ngx-formly/material";
import {
  TranslateLoader,
  TranslateModule,
} from "@ngx-translate/core";
import {NgxsReduxDevtoolsPluginModule} from "@ngxs/devtools-plugin";
import {NgxsLoggerPluginModule} from "@ngxs/logger-plugin";
import {NgxsRouterPluginModule} from "@ngxs/router-plugin";
import {NgxsModule} from "@ngxs/store";
import {TranslateHttpLoaderExtra} from "@shared/http-loader/http-loader-extra";
import {CustomMatPaginatorIntlService} from "@shared/services/custom-mat-paginator-intl.service";
import {ErrorsSkipperService} from "@shared/services/errors-skipper.service";
import {CookieModule} from "ngx-cookie";
import {
  HIGHLIGHT_OPTIONS,
  HighlightModule,
} from "ngx-highlightjs";
import {TourMatMenuModule} from "ngx-tour-md-menu";
import {
  AppConfigService,
  ENVIRONMENT,
  NotificationService,
  NOTIFIER_SERVICE,
  OAuth2Interceptor,
  OAuthStorage,
  SNACK_BAR,
} from "solidify-frontend";
import {environment} from "../environments/environment";
import {AppComponent} from "./app.component";
import {LanguageSelectorPresentational} from "./components/presentationals/language-selector/language-selector.presentational";
import {MainToolbarDesktopHorizontalPresentational} from "./components/presentationals/main-toolbar/main-toolbar-desktop-horizontal/main-toolbar-desktop-horizontal.presentational";
import {PageNotFoundPresentational} from "./components/presentationals/page-not-found/page-not-found.presentational";

const presentationals = [
  AppComponent,
  LanguageSelectorPresentational,
  MainToolbarPresentational,
  MainToolbarDesktopHorizontalPresentational,
  MainToolbarDesktopVerticalPresentational,
  MainToolbarMobilePresentational,
  BurgerMenuPresentational,
  PageNotFoundPresentational,
  ThemeSelectorPresentational,
  ThemeSelectorMenuPresentational,
  GuidedTourMenuPresentational,
  UserMenuPresentational,
  UserFormPresentational,
  CookieConsentPresentational,
  RibbonPresentational,
];

const containers = [
  FooterContainer,
];

const routables = [
  IconAppRoutable,
  MaintenanceModeRoutable,
  ServerOfflineModeRoutable,
];

const dialogs = [
  TokenDialog,
  UserDialog,
  UpdateVersionDialog,
  FirstLoginDialog,
];

export const appModuleState = [
  AppState,
  AppUserState,
  AppPersonState,
  AppAuthorizedOrganizationalUnitState,
  AppOrganizationalUnitPersonRoleState,
  AppArchiveAclState,
  AppCartState,
  AppCartArchiveState,
  AppCartOrderState,
  AppCartDipState,
  AppCartDipDataFileState,
  AppTocState,
  AppNotificationInboxState,
  AppSystemPropertyState,
  AppBannerState,
  AppCarouselState,
];

const appInitializerFn = (appConfig: AppConfigService) => () => appConfig.mergeConfig(environment).toPromise();

export const WINDOW = "windowObject";

export function createDefaultStorage(): Storage | null {
  return environment.tokenInMemoryStorage ? new InMemoryStorage() : (typeof sessionStorage !== "undefined" ? sessionStorage : null);
}

@NgModule({
  declarations: [
    ...presentationals,
    ...containers,
    ...routables,
    ...dialogs,
  ],
  imports: [
    // angular
    BrowserModule,
    BrowserAnimationsModule,
    HttpClientModule,
    CookieModule.forRoot(),

    // NgXs
    NgxsModule.forRoot([
      ...appModuleState,
    ], {
      developmentMode: !environment.production, // Allow to enable freeze store in dev env
    }),
    NgxsLoggerPluginModule.forRoot({
      logger: console,
      collapsed: false,
      disabled: environment.production,
    }),
    NgxsReduxDevtoolsPluginModule.forRoot({
      disabled: environment.production,
    }),
    NgxsRouterPluginModule.forRoot(),

    // NgTranslate
    TranslateModule.forRoot({
      loader: {
        provide: TranslateLoader,
        useFactory: HttpLoaderFactory,
        deps: [HttpClient],
      },
    }),

    // Shared
    SharedModule,

    // App
    AppRoutingModule,
    HighlightModule,
    ServiceWorkerModule.register("./ngsw-worker-custom.js", {
      enabled: environment.production,
      registrationStrategy: "registerImmediately",
      scope: window.location.pathname.replace(/\/[^\/]+$/, "/"),
    }),
    ReactiveFormsModule,
    FormlyModule.forRoot(),
    FormlyMaterialModule,

    TourMatMenuModule.forRoot(),
  ],
  providers: [
    {
      provide: ENVIRONMENT,
      useValue: environment,
    },
    {
      provide: NOTIFIER_SERVICE,
      useValue: NotificationService,
    },
    {
      provide: APP_INITIALIZER,
      useFactory: appInitializerFn,
      multi: true,
      deps: [AppConfigService],
    },
    {
      provide: HTTP_INTERCEPTORS,
      useExisting: OAuth2Interceptor,
      multi: true,
    },
    {
      provide: OAuthStorage,
      useFactory: createDefaultStorage,
    },
    {
      provide: MatPaginatorIntl,
      useClass: CustomMatPaginatorIntlService,
    },
    {
      provide: ErrorHandler,
      useClass: DlcmErrorsHandlerService,
    },
    {
      provide: SNACK_BAR,
      useClass: MatSnackBar,
    },
    {
      provide: WINDOW,
      useValue: window,
    },
    {
      provide: MAT_MOMENT_DATE_ADAPTER_OPTIONS,
      useValue: {
        useUtc: true,
      },
    },
    {provide: MAT_DATE_LOCALE, useValue: navigator.language},
    {provide: DateAdapter, useClass: MomentDateAdapter, deps: [MAT_DATE_LOCALE]},
    {provide: MAT_DATE_FORMATS, useValue: MAT_MOMENT_DATE_FORMATS},
    ErrorsSkipperService,
    {
      provide: HIGHLIGHT_OPTIONS,
      useValue: {
        coreLibraryLoader: () => import("highlight.js/lib/core"),
        languages: {
          xml: () => import("highlight.js/lib/languages/xml"),
          json: () => import("highlight.js/lib/languages/json"),
        },
      },
    },
  ],
  entryComponents: [
    ...dialogs,
  ],
  bootstrap: [AppComponent],
})
export class AppModule {
}

// required for AOT compilation
export function HttpLoaderFactory(http: HttpClient): TranslateHttpLoaderExtra {
  return new TranslateHttpLoaderExtra(http, `.json?cacheBuster=${versions.version}${versions.branch}${versions.revision}`);
}
